/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.keycloak.common.Profile;
import org.keycloak.config.CachingOptions;
import org.keycloak.config.Option;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.MetricsPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.utils.StringUtil;

final class CachingPropertyMappers {
    private static final String REMOTE_HOST_SET = "remote host is set";
    private static final String MULTI_SITE_OR_EMBEDDED_REMOTE_FEATURE_SET = "feature '%s', '%s' or '%s' is set".formatted(Profile.Feature.MULTI_SITE.getKey(), Profile.Feature.CLUSTERLESS.getKey(), Profile.Feature.CACHE_EMBEDDED_REMOTE_STORE.getKey());
    private static final String MULTI_SITE_FEATURE_SET = "feature '%s' or '%s' is set".formatted(Profile.Feature.MULTI_SITE.getKey(), Profile.Feature.CLUSTERLESS.getKey());
    private static final String CACHE_STACK_SET_TO_ISPN = "'cache' type is set to '" + CachingOptions.Mechanism.ispn.name() + "'";

    private CachingPropertyMappers() {
    }

    public static PropertyMapper<?>[] getClusteringPropertyMappers() {
        List<PropertyMapper> staticMappers = List.of(PropertyMapper.fromOption(CachingOptions.CACHE).paramLabel("type").build(), PropertyMapper.fromOption(CachingOptions.CACHE_STACK).isEnabled(CachingPropertyMappers::cacheSetToInfinispan, CACHE_STACK_SET_TO_ISPN).to("kc.spi-connections-infinispan-quarkus-stack").paramLabel("stack").build(), PropertyMapper.fromOption(CachingOptions.CACHE_CONFIG_FILE).mapFrom(CachingOptions.CACHE, (value, context) -> {
            if (CachingOptions.Mechanism.local.name().equals(value)) {
                return "cache-local.xml";
            }
            if (CachingOptions.Mechanism.ispn.name().equals(value)) {
                return CachingPropertyMappers.resolveConfigFile("cache-ispn.xml", null);
            }
            return null;
        }).to("kc.spi-connections-infinispan-quarkus-config-file").transformer(CachingPropertyMappers::resolveConfigFile).validator(s -> {
            if (!Files.exists(Paths.get(CachingPropertyMappers.resolveConfigFile(s, null), new String[0]), new LinkOption[0])) {
                throw new PropertyException("Cache config file '%s' does not exist in the conf directory".formatted(s));
            }
        }).paramLabel("file").build(), PropertyMapper.fromOption(CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED).isEnabled(CachingPropertyMappers::getDefaultMtlsEnabled, "a TCP based cache-stack is used").build(), PropertyMapper.fromOption(CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE.withRuntimeSpecificDefault((Object)CachingPropertyMappers.getDefaultKeystorePathValue())).paramLabel("file").isEnabled(() -> Configuration.isTrue((Option<Boolean>)CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED), "property '%s' is enabled".formatted(CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED.getKey())).validator(value -> CachingPropertyMappers.checkOptionPresent((Option<String>)CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE, (Option<String>)CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE_PASSWORD)).build(), PropertyMapper.fromOption(CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE_PASSWORD).paramLabel("password").isMasked(true).isEnabled(() -> Configuration.isTrue((Option<Boolean>)CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED), "property '%s' is enabled".formatted(CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED.getKey())).validator(value -> CachingPropertyMappers.checkOptionPresent((Option<String>)CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE_PASSWORD, (Option<String>)CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE)).build(), PropertyMapper.fromOption(CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE.withRuntimeSpecificDefault((Object)CachingPropertyMappers.getDefaultTruststorePathValue())).paramLabel("file").isEnabled(() -> Configuration.isTrue((Option<Boolean>)CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED), "property '%s' is enabled".formatted(CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED.getKey())).validator(value -> CachingPropertyMappers.checkOptionPresent((Option<String>)CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE, (Option<String>)CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE_PASSWORD)).build(), PropertyMapper.fromOption(CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE_PASSWORD).paramLabel("password").isMasked(true).isEnabled(() -> Configuration.isTrue((Option<Boolean>)CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED), "property '%s' is enabled".formatted(CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED.getKey())).validator(value -> CachingPropertyMappers.checkOptionPresent((Option<String>)CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE_PASSWORD, (Option<String>)CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE)).build(), PropertyMapper.fromOption(CachingOptions.CACHE_EMBEDDED_MTLS_ROTATION).paramLabel("days").isEnabled(() -> Configuration.isTrue((Option<Boolean>)CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED), "property '%s' is enabled".formatted(CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED.getKey())).validator(CachingPropertyMappers::validateCertificateRotationIsPositive).build(), PropertyMapper.fromOption(CachingOptions.CACHE_REMOTE_HOST).paramLabel("hostname").addValidateEnabled(CachingPropertyMappers::isRemoteCacheHostEnabled, MULTI_SITE_OR_EMBEDDED_REMOTE_FEATURE_SET).isRequired(InfinispanUtils::isRemoteInfinispan, MULTI_SITE_FEATURE_SET).build(), PropertyMapper.fromOption(CachingOptions.CACHE_REMOTE_PORT).isEnabled(CachingPropertyMappers::remoteHostSet, REMOTE_HOST_SET).paramLabel("port").build(), PropertyMapper.fromOption(CachingOptions.CACHE_REMOTE_TLS_ENABLED).isEnabled(CachingPropertyMappers::remoteHostSet, REMOTE_HOST_SET).build(), PropertyMapper.fromOption(CachingOptions.CACHE_REMOTE_USERNAME).isEnabled(CachingPropertyMappers::remoteHostSet, REMOTE_HOST_SET).validator(value -> CachingPropertyMappers.validateCachingOptionIsPresent(CachingOptions.CACHE_REMOTE_USERNAME, CachingOptions.CACHE_REMOTE_PASSWORD)).paramLabel("username").build(), PropertyMapper.fromOption(CachingOptions.CACHE_REMOTE_PASSWORD).isEnabled(CachingPropertyMappers::remoteHostSet, REMOTE_HOST_SET).validator(value -> CachingPropertyMappers.validateCachingOptionIsPresent(CachingOptions.CACHE_REMOTE_PASSWORD, CachingOptions.CACHE_REMOTE_USERNAME)).paramLabel("password").isMasked(true).build(), PropertyMapper.fromOption(CachingOptions.CACHE_METRICS_HISTOGRAMS_ENABLED).isEnabled(MetricsPropertyMappers::metricsEnabled, "metrics are enabled").build());
        int numMappers = staticMappers.size() + CachingOptions.LOCAL_MAX_COUNT_CACHES.length + CachingOptions.CLUSTERED_MAX_COUNT_CACHES.length;
        ArrayList mappers = new ArrayList(numMappers);
        mappers.addAll(staticMappers);
        for (String cache : CachingOptions.LOCAL_MAX_COUNT_CACHES) {
            mappers.add(CachingPropertyMappers.maxCountOpt(cache, () -> true, ""));
        }
        for (String cache : CachingOptions.CLUSTERED_MAX_COUNT_CACHES) {
            mappers.add(CachingPropertyMappers.maxCountOpt(cache, InfinispanUtils::isEmbeddedInfinispan, "embedded Infinispan clusters configured"));
        }
        return mappers.toArray(new PropertyMapper[0]);
    }

    private static boolean getDefaultMtlsEnabled() {
        if (!CachingPropertyMappers.cacheSetToInfinispan()) {
            return false;
        }
        Optional<String> cacheStackOptional = Configuration.getOptionalKcValue(CachingOptions.CACHE_STACK);
        if (cacheStackOptional.isEmpty()) {
            return true;
        }
        String cacheStack = cacheStackOptional.get();
        return !cacheStack.equals("udp") && !cacheStack.equals("jdbc-ping-udp");
    }

    private static boolean remoteHostSet() {
        return Configuration.getOptionalKcValue("cache-remote-host").isPresent();
    }

    private static boolean cacheSetToInfinispan() {
        if (InfinispanUtils.isRemoteInfinispan()) {
            return false;
        }
        Optional<String> cache = Configuration.getOptionalKcValue(CachingOptions.CACHE);
        if (cache.isEmpty() && !Environment.isDevMode()) {
            return true;
        }
        return cache.isPresent() && cache.get().equals(CachingOptions.Mechanism.ispn.name());
    }

    private static String resolveConfigFile(String value, ConfigSourceInterceptorContext context) {
        String homeDir = Environment.getHomeDir();
        return homeDir == null ? value : homeDir + File.separator + "conf" + File.separator + value;
    }

    private static String getDefaultKeystorePathValue() {
        File file;
        String homeDir = Environment.getHomeDir();
        if (homeDir != null && (file = Paths.get(homeDir, "conf", "cache-mtls-keystore.p12").toFile()).exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    private static String getDefaultTruststorePathValue() {
        File file;
        String homeDir = Environment.getHomeDir();
        if (homeDir != null && (file = Paths.get(homeDir, "conf", "cache-mtls-truststore.p12").toFile()).exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    private static PropertyMapper<?> maxCountOpt(String cacheName, BooleanSupplier isEnabled, String enabledWhen) {
        return PropertyMapper.fromOption(CachingOptions.maxCountOption((String)cacheName)).isEnabled(isEnabled, enabledWhen).paramLabel("max-count").build();
    }

    private static boolean isRemoteCacheHostEnabled() {
        return InfinispanUtils.isRemoteInfinispan() || Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CACHE_EMBEDDED_REMOTE_STORE);
    }

    private static void validateCachingOptionIsPresent(Option<?> optionSet, Option<?> optionRequired) {
        if (Configuration.getOptionalKcValue(optionRequired).isEmpty()) {
            throw new PropertyException("The option '%s' is required when '%s' is set.".formatted(optionRequired.getKey(), optionSet.getKey()));
        }
    }

    private static void checkOptionPresent(Option<String> option, Option<String> requiredOption) {
        if (Configuration.getOptionalKcValue(requiredOption).isPresent()) {
            return;
        }
        throw new PropertyException("The option '%s' requires '%s' to be enabled.".formatted(option.getKey(), requiredOption.getKey()));
    }

    private static void validateCertificateRotationIsPositive(String value) {
        if (StringUtil.isBlank((String)(value = value.trim()))) {
            throw new PropertyException("Option '%s' must not be empty.".formatted(CachingOptions.CACHE_EMBEDDED_MTLS_ROTATION.getKey()));
        }
        try {
            if (Integer.parseInt(value) <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException unused) {
            throw new PropertyException("JGroups MTLS certificate rotation in '%s' option must positive.".formatted(CachingOptions.CACHE_EMBEDDED_MTLS_ROTATION.getKey()));
        }
    }
}

