/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.kafka.image.node.printer.MetadataNodePrinter;
import org.apache.kafka.image.node.printer.NodeStringifier;

public interface MetadataNode {
    default public boolean isDirectory() {
        return true;
    }

    default public Collection<String> childNames() {
        return Collections.emptyList();
    }

    default public MetadataNode child(String name) {
        return null;
    }

    default public void print(MetadataNodePrinter printer) {
        ArrayList<String> names = new ArrayList<String>(this.childNames());
        names.sort(String::compareTo);
        for (String name : names) {
            printer.enterNode(name);
            MetadataNode child = this.child(name);
            if (child != null) {
                child.print(printer);
            }
            printer.leaveNode();
        }
    }

    default public String stringify() {
        NodeStringifier stringifier = new NodeStringifier();
        this.print(stringifier);
        return stringifier.toString();
    }
}

