/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedReader;

public class LimitedLineReader {
    private char[] buf;
    private int cchBuf;
    private int ichCurrent;

    public LimitedLineReader(BufferedReader bufferedReader, int readLimit) throws Exception {
        bufferedReader.mark(readLimit + 1);
        this.buf = new char[readLimit];
        this.cchBuf = Math.max(bufferedReader.read(this.buf, 0, readLimit), 0);
        this.ichCurrent = 0;
        bufferedReader.reset();
    }

    public String getHeader(int n) {
        return n == 0 ? new String(this.buf) : new String(this.buf, 0, Math.min(this.cchBuf, n));
    }

    public String readLineWithNewline() {
        while (this.ichCurrent < this.cchBuf) {
            int ichBeginningOfLine = this.ichCurrent;
            int ch = 0;
            while (this.ichCurrent < this.cchBuf && (ch = this.buf[this.ichCurrent++]) != 13 && ch != 10) {
            }
            if (ch == 13 && this.ichCurrent < this.cchBuf && this.buf[this.ichCurrent] == '\n') {
                ++this.ichCurrent;
            }
            int cchLine = this.ichCurrent - ichBeginningOfLine;
            if (this.buf[ichBeginningOfLine] == '#') continue;
            return new String(this.buf, ichBeginningOfLine, cchLine);
        }
        return "";
    }
}

