/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.function.UnaryOperator;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Undefined;

public class JavaToJSONConverters {
    public static final UnaryOperator<Object> STRING = object -> object.toString();
    public static final UnaryOperator<Object> UNDEFINED = object -> Undefined.instance;
    public static final UnaryOperator<Object> EMPTY_OBJECT = object -> Collections.EMPTY_MAP;
    public static final UnaryOperator<Object> THROW_TYPE_ERROR = object -> {
        throw ScriptRuntime.typeErrorById("msg.json.cant.serialize", object.getClass().getName());
    };
    public static final UnaryOperator<Object> BEAN = object -> {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass(), Object.class);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            Object object2;
            if (propertyDescriptor.getReadMethod() == null) continue;
            try {
                object2 = propertyDescriptor.getReadMethod().invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                continue;
            }
            linkedHashMap.put(propertyDescriptor.getName(), object2);
        }
        if (linkedHashMap.size() == 0) {
            return null;
        }
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        linkedHashMap2.put("beanClass", beanDescriptor.getBeanClass().getName());
        linkedHashMap2.put("properties", linkedHashMap);
        return linkedHashMap2;
    };

    private JavaToJSONConverters() {
    }
}

