/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSStyleDeclaration;

public final class AttributeToStyle {
    public static void align(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        if (string.equalsIgnoreCase("center") || string.equalsIgnoreCase("middle")) {
            cSSStyleDeclaration.setProperty("text-align", "center", null);
        } else if (string.equalsIgnoreCase("justify")) {
            cSSStyleDeclaration.setProperty("text-align", "justify", null);
        } else if (string.equalsIgnoreCase("left")) {
            cSSStyleDeclaration.setProperty("text-align", "left", null);
        } else if (string.equalsIgnoreCase("right")) {
            cSSStyleDeclaration.setProperty("text-align", "right", null);
        }
    }

    public static void bgcolor(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        if ((string = string.trim()).length() != 0) {
            cSSStyleDeclaration.setProperty("background-color", string, null);
        }
    }

    public static void width(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        int n = string.length();
        if (n != 0) {
            char c = string.charAt(n - 1);
            if (AttributeToStyle.isDigit(c)) {
                string = string + "px";
            }
            cSSStyleDeclaration.setProperty("width", string, null);
        }
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static void height(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        int n = string.length();
        if (n != 0) {
            char c = string.charAt(n - 1);
            if (AttributeToStyle.isDigit(c)) {
                string = string + "px";
            }
            cSSStyleDeclaration.setProperty("height", string, null);
        }
    }

    public static void face(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        if ((string = string.trim()).length() != 0) {
            cSSStyleDeclaration.setProperty("font-family", string, null);
        }
    }

    public static void size(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        String string2;
        if ((string = string.trim()).length() != 0 && !(string2 = AttributeToStyle.translateFontSize(string)).isEmpty()) {
            cSSStyleDeclaration.setProperty("font-size", string2, null);
        }
    }

    private static String translateFontSize(String string) {
        int n;
        if (string.charAt(0) == '+') {
            return "larger";
        }
        if (string.charAt(0) == '-') {
            return "smaller";
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
        switch (n) {
            case 1: {
                string = "8px";
                break;
            }
            case 2: {
                string = "10px";
                break;
            }
            case 3: {
                string = "12px";
                break;
            }
            case 4: {
                string = "14px";
                break;
            }
            case 5: {
                string = "18px";
                break;
            }
            case 6: {
                string = "24px";
                break;
            }
            case 7: {
                string = "28px";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static void color(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        if ((string = string.trim()).length() != 0) {
            cSSStyleDeclaration.setProperty("color", string, null);
        }
    }

    public static boolean border(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        int n = (string = string.trim()).length();
        if (n != 0) {
            char c = string.charAt(n - 1);
            if (AttributeToStyle.isDigit(c)) {
                string = string + "px";
            }
            cSSStyleDeclaration.setProperty("border-top-width", string, null);
            cSSStyleDeclaration.setProperty("border-right-width", string, null);
            cSSStyleDeclaration.setProperty("border-bottom-width", string, null);
            cSSStyleDeclaration.setProperty("border-left-width", string, null);
            return true;
        }
        return false;
    }

    public static void borderColor(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        int n = (string = string.trim()).length();
        if (n != 0) {
            cSSStyleDeclaration.setProperty("border-top-color", string, null);
            cSSStyleDeclaration.setProperty("border-right-color", string, null);
            cSSStyleDeclaration.setProperty("border-bottom-color", string, null);
            cSSStyleDeclaration.setProperty("border-left-color", string, null);
        }
    }

    public static void cellSpacing(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        int n = (string = string.trim()).length();
        if (n != 0) {
            char c = string.charAt(n - 1);
            if (AttributeToStyle.isDigit(c)) {
                string = string + "px";
            }
            cSSStyleDeclaration.setProperty("border-spacing", string, null);
        }
    }

    public static void background(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        if ((string = string.trim()).length() != 0) {
            cSSStyleDeclaration.setProperty("background-image", string, null);
        }
    }

    public static void hspace(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        int n = (string = string.trim()).length();
        if (n != 0) {
            char c = string.charAt(n - 1);
            if (AttributeToStyle.isDigit(c)) {
                string = string + "px";
            }
            cSSStyleDeclaration.setProperty("margin-right", string, null);
            cSSStyleDeclaration.setProperty("margin-left", string, null);
        }
    }

    public static void vspace(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        int n = (string = string.trim()).length();
        if (n != 0) {
            char c = string.charAt(n - 1);
            if (AttributeToStyle.isDigit(c)) {
                string = string + "px";
            }
            cSSStyleDeclaration.setProperty("margin-top", string, null);
            cSSStyleDeclaration.setProperty("margin-bottom", string, null);
        }
    }
}

