/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.HashUtil;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class LongObjectHashMap
implements Cloneable,
Iterable<Entry> {
    private final float loadFactor;
    private Entry[] table;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;
    private Object keyNotFoundValue = null;
    private static final boolean isPrimitive;
    private static final Constructor<Entry> entryConstructor;
    private static final Method equalsMethod;

    public LongObjectHashMap() {
        this(16, 0.75f);
    }

    public LongObjectHashMap(int n) {
        this(n, 0.75f);
    }

    public LongObjectHashMap(int n, float f) {
        if (n > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < n) {
            this.capacity <<= 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    private LongObjectHashMap(float f, int n, int n2, int n3, int n4, int n5, Object object) {
        this.loadFactor = f;
        this.table = new Entry[n];
        this.size = n2;
        this.mask = n3;
        this.capacity = n4;
        this.threshold = n5;
        this.keyNotFoundValue = object;
    }

    public Object clone() {
        LongObjectHashMap longObjectHashMap = new LongObjectHashMap(this.loadFactor, this.table.length, this.size, this.mask, this.capacity, this.threshold, this.keyNotFoundValue);
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (int i = this.table.length - 1; i >= 0; --i) {
            Entry entry = this.table[i];
            while (null != entry) {
                arrayList.add(entry);
                entry = entry.next;
            }
            int n = arrayList.size();
            Entry entry2 = null;
            for (int j = n - 1; j >= 0; --j) {
                entry = (Entry)arrayList.remove(j);
                if (isPrimitive) {
                    entry2 = new Entry(entry.key, entry.value, entry2);
                    continue;
                }
                Object object = ReflectionUtil.callMethod(entry.value, LongObjectHashMap.getCloneMethod(entry.value), new Object[0]);
                entry2 = (Entry)ReflectionUtil.createInstance(entryConstructor, entry.key, object, entry2);
            }
            longObjectHashMap.table[i] = entry2;
        }
        return longObjectHashMap;
    }

    public boolean containsValue(Object object) {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                Boolean bl;
                if (isPrimitive ? entry.value == object : (bl = (Boolean)ReflectionUtil.callMethod(object, equalsMethod, entry.value)) != false) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(long l) {
        Entry[] entryArray = this.table;
        int n = HashUtil.getAddrHash32_EqualDist(l) & this.mask;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.key == l) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(long l) {
        Entry[] entryArray = this.table;
        int n = HashUtil.getAddrHash32_EqualDist(l) & this.mask;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.key == l) {
                return entry.value;
            }
            entry = entry.next;
        }
        return this.keyNotFoundValue;
    }

    public Object put(long l, Object object) {
        Entry[] entryArray = this.table;
        int n = HashUtil.getAddrHash32_EqualDist(l) & this.mask;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.key == l) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        entryArray[n] = new Entry(l, object, entryArray[n]);
        if (this.size++ >= this.threshold) {
            int n2 = 2 * this.capacity;
            Entry[] entryArray2 = new Entry[n2];
            int n3 = n2 - 1;
            for (int i = 0; i < entryArray.length; ++i) {
                Entry entry2;
                Entry entry3 = entryArray[i];
                if (entry3 == null) continue;
                entryArray[i] = null;
                do {
                    entry2 = entry3.next;
                    int n4 = HashUtil.getAddrHash32_EqualDist(entry3.key) & n3;
                    entry3.next = entryArray2[n4];
                    entryArray2[n4] = entry3;
                } while ((entry3 = entry2) != null);
            }
            this.table = entryArray2;
            this.capacity = n2;
            this.threshold = (int)((float)n2 * this.loadFactor);
            this.mask = n3;
        }
        return this.keyNotFoundValue;
    }

    public void putAll(LongObjectHashMap longObjectHashMap) {
        for (Entry entry : longObjectHashMap) {
            this.put(entry.key, entry.value);
        }
    }

    public Object remove(long l) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n = HashUtil.getAddrHash32_EqualDist(l) & this.mask;
        Entry entry2 = entry = entryArray[n];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == l) {
                --this.size;
                if (entry == entry2) {
                    entryArray[n] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return this.keyNotFoundValue;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    @Override
    public Iterator<Entry> iterator() {
        return new EntryIterator(this.table);
    }

    public Object setKeyNotFoundValue(Object object) {
        Object object2 = this.keyNotFoundValue;
        this.keyNotFoundValue = object;
        return object2;
    }

    public Object getKeyNotFoundValue() {
        return this.keyNotFoundValue;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("{");
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    private static Method getCloneMethod(Object object) {
        final Class<?> clazz = object.getClass();
        return SecurityUtil.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return clazz.getDeclaredMethod("clone", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new JogampRuntimeException("Class " + clazz + " doesn't support clone()", noSuchMethodException);
                }
            }
        });
    }

    static {
        final Class<Object> clazz = Object.class;
        final Class<Long> clazz2 = Long.TYPE;
        isPrimitive = clazz.isPrimitive();
        if (!isPrimitive) {
            EntryCM entryCM = SecurityUtil.doPrivileged(new PrivilegedAction<EntryCM>(){

                @Override
                public EntryCM run() {
                    EntryCM entryCM = new EntryCM();
                    entryCM.c = ReflectionUtil.getConstructor(Entry.class, clazz2, clazz, Entry.class);
                    try {
                        entryCM.m1 = clazz.getDeclaredMethod("equals", Object.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new JogampRuntimeException("Class " + clazz + " doesn't support equals(Object)");
                    }
                    return entryCM;
                }
            });
            entryConstructor = entryCM.c;
            equalsMethod = entryCM.m1;
        } else {
            entryConstructor = null;
            equalsMethod = null;
        }
    }

    public static final class Entry {
        public final long key;
        public Object value;
        Entry next;

        Entry(long l, Object object, Entry entry) {
            this.key = l;
            this.value = object;
            this.next = entry;
        }

        public long getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public StringBuilder toString(StringBuilder stringBuilder) {
            if (null == stringBuilder) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append("[").append(this.key).append(":").append(this.value).append("]");
            return stringBuilder;
        }

        public String toString() {
            return this.toString(null).toString();
        }
    }

    static class EntryCM {
        Constructor<Entry> c = null;
        Method m1 = null;

        EntryCM() {
        }
    }

    private static final class EntryIterator
    implements Iterator<Entry> {
        private final Entry[] entries;
        private int index;
        private Entry next;

        private EntryIterator(Entry[] entryArray) {
            this.entries = entryArray;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Entry next() {
            Entry entry = this.next;
            if (entry != null && entry.next != null) {
                this.next = entry.next;
            } else {
                while (this.index < this.entries.length) {
                    Entry entry2;
                    if ((entry2 = this.entries[this.index++]) == null) continue;
                    this.next = entry2;
                    return entry;
                }
                this.next = null;
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

