/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.NDTNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

abstract class NamespacedNode
extends NDTNode {
    private static final long serialVersionUID = 1L;
    private final String namespaceUri;
    private String prefix = null;

    public NamespacedNode(short s, String string) {
        super(s);
        this.namespaceUri = string;
    }

    @Override
    void checkAppendNodeHierarchy(Node node) {
        super.checkAppendNodeHierarchy(node);
        if (node.getNodeType() == 10) {
            throw new DOMException(3, "Cannot append a document type here.");
        }
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceUri;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String string) throws DOMException {
        String string2 = this.getNamespaceURI();
        if (string2 != null && !this.isDefaultNamespace(string2)) {
            if ("xml".equals(string) && "http://www.w3.org/XML/1998/namespace" != this.getNamespaceURI()) {
                throw new DOMException(14, "Wrong namespace for prefix xml");
            }
            if (string != null && !DOMDocument.isValidName(string)) {
                throw new DOMException(5, "Invalid prefix");
            }
            this.prefix = string;
        } else if (string != null && string.length() != 0) {
            throw new DOMException(14, "Cannot put a prefix to default namespace.");
        }
    }

    @Override
    public String lookupNamespaceURI(String string) {
        if (string == null) {
            if (this.getPrefix() == null) {
                return this.getNamespaceURI();
            }
        } else {
            if (string.equals(this.getPrefix())) {
                return this.getNamespaceURI();
            }
            if ("xml".equals(string)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
        }
        return null;
    }

    @Override
    public String lookupPrefix(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(this.getNamespaceURI())) {
            return this.getPrefix();
        }
        return null;
    }
}

