/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.uparser;

import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenHandler2;

public class CommentRemovalHandler
implements TokenHandler2 {
    private final StringBuilder buffer;

    public CommentRemovalHandler(int n) {
        this(new StringBuilder(n));
    }

    public CommentRemovalHandler(StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    @Override
    public void tokenStart(TokenControl tokenControl) {
    }

    @Override
    public void word(int n, CharSequence charSequence) {
        this.buffer.append(charSequence);
    }

    @Override
    public void separator(int n, int n2) {
        this.buffer.appendCodePoint(n2);
    }

    @Override
    public void quoted(int n, CharSequence charSequence, int n2) {
        char[] cArray = Character.toChars(n2);
        this.buffer.append(cArray);
        this.buffer.append(charSequence);
        this.buffer.append(cArray);
    }

    @Override
    public void quotedWithControl(int n, CharSequence charSequence, int n2) {
        this.quoted(n, charSequence, n2);
    }

    @Override
    public void quotedNewlineChar(int n, int n2) {
        this.buffer.appendCodePoint(n2);
    }

    @Override
    public void leftParenthesis(int n) {
        this.buffer.append('(');
    }

    @Override
    public void leftSquareBracket(int n) {
        this.buffer.append('[');
    }

    @Override
    public void leftCurlyBracket(int n) {
        this.buffer.append('{');
    }

    @Override
    public void rightParenthesis(int n) {
        this.buffer.append(')');
    }

    @Override
    public void rightSquareBracket(int n) {
        this.buffer.append(']');
    }

    @Override
    public void rightCurlyBracket(int n) {
        this.buffer.append('}');
    }

    @Override
    public void character(int n, int n2) {
        this.buffer.appendCodePoint(n2);
    }

    @Override
    public void escaped(int n, int n2) {
        this.buffer.append('\\').appendCodePoint(n2);
    }

    @Override
    public void control(int n, int n2) {
        this.buffer.appendCodePoint(n2);
    }

    @Override
    public void commented(int n, int n2, String string) {
    }

    @Override
    public void endOfStream(int n) {
    }

    @Override
    public void error(int n, byte by, CharSequence charSequence) {
    }
}

