/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class JRestrictedSizeScrollPane
extends JScrollPane {
    public JRestrictedSizeScrollPane() {
        this.getViewport().addComponentListener(new SizeChanger());
    }

    public JRestrictedSizeScrollPane(Component view) {
        super(view);
        this.getViewport().addComponentListener(new SizeChanger());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.isPreferredSizeSet() || !this.isMaximumSizeSet() && !this.isMinimumSizeSet()) {
            return preferredSize;
        }
        if (this.isMinimumSizeSet()) {
            Dimension minimumSize = this.getMinimumSize();
            preferredSize.width = Math.max(minimumSize.width, preferredSize.width);
            preferredSize.height = Math.max(minimumSize.height, preferredSize.height);
        }
        if (this.isMaximumSizeSet()) {
            Dimension maximumSize = this.getMaximumSize();
            preferredSize.width = Math.min(maximumSize.width, preferredSize.width);
            preferredSize.height = Math.min(maximumSize.height, preferredSize.height);
        }
        return preferredSize;
    }

    private static class SizeChanger
    extends ComponentAdapter {
        private SizeChanger() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            JViewport viewport = (JViewport)e.getComponent();
            Dimension extentSize = viewport.getExtentSize();
            Component view = viewport.getView();
            if (view != null && !view.getSize().equals(extentSize)) {
                view.setSize(extentSize);
                viewport.revalidate();
            }
        }
    }
}

