/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import groovy.lang.Closure;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.NumberMath;
import org.freeplane.api.ChildNodesLayout;
import org.freeplane.api.Cloud;
import org.freeplane.api.ConditionalStyles;
import org.freeplane.api.Connector;
import org.freeplane.api.DependencyLookup;
import org.freeplane.api.LayoutOrientation;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Node;
import org.freeplane.api.NodeCondition;
import org.freeplane.api.NodeGeometry;
import org.freeplane.api.NodeRO;
import org.freeplane.api.NodeStyle;
import org.freeplane.api.NodeToComparableMapper;
import org.freeplane.api.Quantity;
import org.freeplane.api.Reminder;
import org.freeplane.api.Side;
import org.freeplane.api.Tags;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.encrypt.Base64Coding;
import org.freeplane.features.encrypt.PasswordStrategy;
import org.freeplane.features.explorer.AccessedNodes;
import org.freeplane.features.explorer.MapExplorer;
import org.freeplane.features.explorer.NodeNotFoundException;
import org.freeplane.features.explorer.mindmapmode.MMapExplorerController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.layout.mindmapmode.MLayoutController;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapNavigationUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.clipboard.MindMapPlainTextWriter;
import org.freeplane.features.map.mindmapmode.InsertionRelation;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.clipboard.MMapClipboardController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.ViewController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.dependencies.DependencySearchStrategy;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.AttributesProxy;
import org.freeplane.plugin.script.proxy.CloudProxy;
import org.freeplane.plugin.script.proxy.ConnectorInListProxy;
import org.freeplane.plugin.script.proxy.ConnectorOutListProxy;
import org.freeplane.plugin.script.proxy.ConnectorProxy;
import org.freeplane.plugin.script.proxy.Convertible;
import org.freeplane.plugin.script.proxy.ConvertibleHtmlText;
import org.freeplane.plugin.script.proxy.ConvertibleNoteText;
import org.freeplane.plugin.script.proxy.DependencyLookupProxy;
import org.freeplane.plugin.script.proxy.ExternalObjectProxy;
import org.freeplane.plugin.script.proxy.IconsProxy;
import org.freeplane.plugin.script.proxy.LinkProxy;
import org.freeplane.plugin.script.proxy.MapProxy;
import org.freeplane.plugin.script.proxy.NodeConditionalStylesProxy;
import org.freeplane.plugin.script.proxy.NodeGeometryProxy;
import org.freeplane.plugin.script.proxy.NodeStyleProxy;
import org.freeplane.plugin.script.proxy.Proxy;
import org.freeplane.plugin.script.proxy.ProxyUtils;
import org.freeplane.plugin.script.proxy.ReminderProxy;
import org.freeplane.plugin.script.proxy.TagsProxy;

class NodeProxy
extends AbstractProxy<NodeModel>
implements Proxy.Node {
    private static final Integer ONE = 1;
    private static final Integer ZERO = 0;

    public NodeProxy(NodeModel node, ScriptContext scriptContext) {
        super(node, scriptContext);
        this.reportOwnedNodeAccess();
    }

    public Proxy.Connector addConnectorTo(Node target) {
        return this.addConnectorTo(target.getId());
    }

    public Proxy.Connector addConnectorTo(String targetNodeID) {
        MLinkController linkController = (MLinkController)this.getLinkController();
        ConnectorModel connectorModel = linkController.addConnector((NodeModel)this.getDelegate(), targetNodeID);
        return new ConnectorProxy(connectorModel, this.getScriptContext());
    }

    private LinkController getLinkController() {
        return LinkController.getController((ModeController)this.getModeController());
    }

    public Node createChild() {
        return this.createChild("");
    }

    private NodeModel extracted(NodeModel target, Object value) {
        return new NodeModel(value, target.getMap());
    }

    private MMapController getMapController() {
        return (MMapController)this.getModeController().getMapController();
    }

    public Node createChild(Object value) {
        return this.createChild((NodeModel)this.getDelegate(), value, ((NodeModel)this.getDelegate()).getChildCount());
    }

    private Node createChild(NodeModel parent, Object value, int position) {
        NodeModel newNodeModel = this.extracted(parent, value);
        if (parent.isRoot()) {
            newNodeModel.setSide(MapController.suggestNewChildSide((NodeModel)parent, (NodeModel.Side)NodeModel.Side.DEFAULT));
        }
        this.getMapController().insertNode(newNodeModel, parent, position);
        return new NodeProxy(newNodeModel, this.getScriptContext());
    }

    public Node createChild(int position) {
        return this.createChild((NodeModel)this.getDelegate(), "", position);
    }

    public Node appendChild(NodeRO node) {
        return this.appendBranchImpl(node, false);
    }

    public Node appendBranch(NodeRO node) {
        return this.appendBranchImpl(node, true);
    }

    private Node appendBranchImpl(NodeRO node, boolean withChildren) {
        MMapClipboardController clipboardController = (MMapClipboardController)this.getClipboardController();
        NodeModel source = (NodeModel)((NodeProxy)node).getDelegate();
        NodeModel target = (NodeModel)this.getDelegate();
        NodeModel newNodeModel = clipboardController.duplicate(source, target.getMap(), withChildren);
        newNodeModel.setSide(MapController.suggestNewChildSide((NodeModel)target, (NodeModel.Side)NodeModel.Side.DEFAULT));
        NodeModel parent = target;
        this.getMapController().insertNode(newNodeModel, parent, parent.getChildCount());
        return new NodeProxy(newNodeModel, this.getScriptContext());
    }

    public void delete() {
        this.getMapController().deleteNode((NodeModel)this.getDelegate());
    }

    public Proxy.Attributes getAttributes() {
        return AttributesProxy.withRawValues((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    public Convertible getAt(String attributeName) {
        Object value = this.getAttributes().getFirst(attributeName);
        return ProxyUtils.attributeValueToConvertible((NodeModel)this.getDelegate(), this.getScriptContext(), value);
    }

    public Object putAt(String attributeName, Object value) {
        Proxy.Attributes attributes = this.getAttributes();
        if (value == null) {
            int index = attributes.findFirst(attributeName);
            if (index != -1) {
                attributes.remove(index);
            }
        } else {
            attributes.set(attributeName, value);
        }
        return value;
    }

    public void setAttributes(Map<String, Object> attributeMap) {
        Proxy.Attributes attributes = this.getAttributes();
        attributes.clear();
        for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
            attributes.set(entry.getKey(), entry.getValue());
        }
    }

    public void setDetails(Object details) {
        this.setDetailsText(Convertible.toString(details));
    }

    public void setDetailsText(String text) {
        MTextController textController = (MTextController)this.getTextController();
        NodeModel delegate = (NodeModel)this.getDelegate();
        if (text == null || text.isEmpty()) {
            textController.setDetailsHidden(delegate, false);
            textController.setDetails(delegate, null);
        } else {
            String detailsContentType = textController.getDetailsContentType(delegate);
            textController.setDetails(delegate, !HtmlUtils.isHtml((String)text) && TextController.isHtmlContentType((String)detailsContentType) ? HtmlUtils.textToHTML((String)text) : text);
        }
    }

    public void setHideDetails(boolean hide) {
        MTextController controller = (MTextController)this.getTextController();
        controller.setDetailsHidden((NodeModel)this.getDelegate(), hide);
    }

    public int getChildPosition(Node childNode) {
        NodeModel childNodeModel = (NodeModel)((NodeProxy)childNode).getDelegate();
        return ((NodeModel)this.getDelegate()).getIndex(childNodeModel);
    }

    public List<Proxy.Node> getChildren() {
        return ProxyUtils.createListOfChildren((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    public Cloud getCloud() {
        return new CloudProxy(this);
    }

    public Collection<Proxy.Connector> getConnectorsIn() {
        return new ConnectorInListProxy(this);
    }

    public Collection<Proxy.Connector> getConnectorsOut() {
        return new ConnectorOutListProxy(this);
    }

    public Convertible getDetails() {
        String detailsText = DetailModel.getDetailText((NodeModel)((NodeModel)this.getDelegate()));
        return detailsText == null ? null : new ConvertibleHtmlText((NodeModel)this.getDelegate(), this.getScriptContext(), detailsText);
    }

    public String getDetailsText() {
        return DetailModel.getDetailText((NodeModel)((NodeModel)this.getDelegate()));
    }

    public String getDetailsContentType() {
        NodeModel nodeModel = (NodeModel)this.getDelegate();
        String contentType = this.getTextController().getDetailsContentType(nodeModel);
        return contentType;
    }

    public void setDetailsContentType(String contentType) {
        MTextController textController = (MTextController)this.getTextController();
        if (contentType != null) {
            if (!Stream.of(textController.getDetailContentTypes()).anyMatch(contentType::equals)) {
                throw new IllegalArgumentException("Unknown content type " + contentType);
            }
        }
        NodeModel nodeModel = (NodeModel)this.getDelegate();
        textController.setDetailsContentType(nodeModel, contentType);
    }

    public boolean getHideDetails() {
        DetailModel detailText = DetailModel.getDetail((NodeModel)((NodeModel)this.getDelegate()));
        return detailText != null && detailText.isHidden();
    }

    public Proxy.ExternalObject getExternalObject() {
        return new ExternalObjectProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    public Proxy.Icons getIcons() {
        return new IconsProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    public Proxy.Link getLink() {
        return new LinkProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    public Reminder getReminder() {
        return new ReminderProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    public String getId() {
        return ((NodeModel)this.getDelegate()).createID();
    }

    @Deprecated
    public String getNodeID() {
        return this.getId();
    }

    public int getNodeLevel(boolean countHidden) {
        NodeModel node = (NodeModel)this.getDelegate();
        return countHidden ? node.getNodeLevel() : node.getNodeLevel(FilterController.getFilter((MapModel)node.getMap()));
    }

    public String getPlainNote() {
        String noteText = NoteModel.getNoteText((NodeModel)((NodeModel)this.getDelegate()));
        return noteText == null ? null : HtmlUtils.htmlToPlain((String)noteText);
    }

    public String getNoteText() {
        return NoteModel.getNoteText((NodeModel)((NodeModel)this.getDelegate()));
    }

    public Convertible getNote() {
        String noteText = this.getNoteText();
        return noteText == null ? null : new ConvertibleNoteText((NodeModel)this.getDelegate(), this.getScriptContext(), noteText);
    }

    public String getNoteContentType() {
        NodeModel nodeModel = (NodeModel)this.getDelegate();
        String contentType = this.getNoteController().getNoteContentType(nodeModel);
        return contentType;
    }

    public void setNoteContentType(String contentType) {
        MNoteController noteController = (MNoteController)this.getNoteController();
        if (contentType != null) {
            if (!Stream.of(noteController.getNoteContentTypes()).anyMatch(contentType::equals)) {
                throw new IllegalArgumentException("Unknown content type " + contentType);
            }
        }
        NodeModel nodeModel = (NodeModel)this.getDelegate();
        noteController.setNoteContentType(nodeModel, contentType);
    }

    public Node getParent() {
        NodeModel parentNode = ((NodeModel)this.getDelegate()).getParentNode();
        return parentNode != null ? new NodeProxy(parentNode, this.getScriptContext()) : null;
    }

    @Deprecated
    public Node getParentNode() {
        return this.getParent();
    }

    public List<? extends Node> getPathToRoot() {
        return ProxyUtils.createNodeList(Arrays.asList(((NodeModel)this.getDelegate()).getPathToRoot()), this.getScriptContext());
    }

    public Node getNext() {
        NodeModel node = MapNavigationUtils.findNext((MapController.Direction)MapController.Direction.FORWARD, (NodeModel)((NodeModel)this.getDelegate()), null);
        return node == null ? null : new NodeProxy(node, this.getScriptContext());
    }

    public Node getPrevious() {
        NodeModel node = MapNavigationUtils.findPrevious((MapController.Direction)MapController.Direction.BACK, (NodeModel)((NodeModel)this.getDelegate()), null);
        return node == null ? null : new NodeProxy(node, this.getScriptContext());
    }

    public String getPlainText() {
        NodeModel node = this.getDelegateForValueAccess();
        return HtmlUtils.htmlToPlain((String)node.getText());
    }

    private NodeModel getDelegateForValueAccess() {
        this.reportValueAccess();
        return (NodeModel)this.getDelegate();
    }

    private void reportValueAccess() {
        ScriptContext scriptContext = this.getScriptContext();
        if (scriptContext != null) {
            scriptContext.accessValue((NodeModel)this.getDelegate());
        }
    }

    @Deprecated
    public String getPlainTextContent() {
        return this.getPlainText();
    }

    public String getHtmlText() {
        NodeModel node = this.getDelegateForValueAccess();
        String nodeText = node.getText();
        if (HtmlUtils.isHtml((String)nodeText)) {
            return nodeText;
        }
        return HtmlUtils.plainToHTML((String)nodeText);
    }

    public NodeStyle getStyle() {
        return new NodeStyleProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    public boolean hasStyle(String styleName) {
        return NodeStyleProxy.hasStyle((NodeModel)this.getDelegate(), styleName);
    }

    public ConditionalStyles getConditionalStyles() {
        return new NodeConditionalStylesProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    public String getText() {
        return this.getDelegateForValueAccess().getText();
    }

    public String getTransformedText() {
        TextController textController = this.getTextController();
        return textController.getTransformedTextNoThrow(this.getDelegateForValueAccess());
    }

    public String getShortText() {
        TextController textController = this.getTextController();
        return textController.getShortPlainText(this.getDelegateForValueAccess());
    }

    public String getDisplayedText() {
        if (this.isMinimized()) {
            return this.getShortText();
        }
        return this.getTransformedText();
    }

    public boolean isMinimized() {
        TextController textController = this.getTextController();
        return textController.isMinimized((NodeModel)this.getDelegate());
    }

    public Object getObject() {
        NodeModel node = this.getDelegateForValueAccess();
        Object userObject = node.getUserObject();
        if (userObject instanceof IFormattedObject) {
            return ((IFormattedObject)userObject).getObject();
        }
        return userObject;
    }

    public byte[] getBinary() {
        NodeModel node = this.getDelegateForValueAccess();
        return Base64Coding.decode64((String)node.getText().replaceAll("\\s", ""));
    }

    public String getFormat() {
        NodeModel nodeModel = (NodeModel)this.getDelegate();
        String format = this.getTextController().getNodeFormat(nodeModel);
        if (format == null && nodeModel.getUserObject() instanceof IFormattedObject) {
            return ((IFormattedObject)nodeModel.getUserObject()).getPattern();
        }
        return format;
    }

    public Convertible getTo() {
        NodeModel node = this.getDelegateForValueAccess();
        return ProxyUtils.nodeModelToConvertible(node, this.getScriptContext());
    }

    public Convertible getValue() {
        return this.getTo();
    }

    public boolean isDescendantOf(Node otherNode) {
        NodeModel otherNodeModel = (NodeModel)((NodeProxy)otherNode).getDelegate();
        NodeModel node = (NodeModel)this.getDelegate();
        do {
            if (!node.equals(otherNodeModel)) continue;
            return true;
        } while ((node = node.getParentNode()) != null);
        return false;
    }

    public boolean isFolded() {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        NodeModel node = (NodeModel)this.getDelegate();
        return selection != null ? selection.isFolded(node) : node.isFolded();
    }

    public boolean isFree() {
        FreeNode freeNode = this.getFreeNodeHook();
        return freeNode.isActive((NodeModel)this.getDelegate());
    }

    public boolean isLeaf() {
        return ((NodeModel)this.getDelegate()).isLeaf();
    }

    public boolean isTopOrLeft() {
        NodeModel node = (NodeModel)this.getDelegate();
        return node.isTopOrLeft(node.getMap().getRootNode());
    }

    public Side getSideAtRoot() {
        return Side.values()[((NodeModel)this.getDelegate()).getSide().ordinal()];
    }

    public boolean isTopOrLeftOnViewsWithRoot(NodeRO viewRoot) {
        if (!(viewRoot instanceof NodeProxy)) {
            return false;
        }
        NodeModel node = (NodeModel)this.getDelegate();
        NodeModel root = (NodeModel)((NodeProxy)viewRoot).getDelegate();
        return node.isTopOrLeft(root);
    }

    public boolean isRoot() {
        return ((NodeModel)this.getDelegate()).isRoot();
    }

    public boolean isVisible() {
        NodeModel node = (NodeModel)this.getDelegate();
        return ((NodeModel)this.getDelegate()).hasVisibleContent(FilterController.getFilter((MapModel)node.getMap()));
    }

    public boolean isVisibleOnViewsWithRoot(NodeRO viewRoot) {
        NodeModel root;
        if (!(viewRoot instanceof NodeProxy)) {
            return false;
        }
        NodeModel node = (NodeModel)this.getDelegate();
        return node == (root = (NodeModel)((NodeProxy)viewRoot).getDelegate()) || root.getMap() == node.getMap() && node.isDescendantOf(root) && this.isVisible();
    }

    public void moveTo(Node parentNodeProxy) {
        NodeModel parentNode = (NodeModel)((NodeProxy)parentNodeProxy).getDelegate();
        NodeModel movedNode = (NodeModel)this.getDelegate();
        this.getMapController().moveNodes(Arrays.asList(movedNode), parentNode, InsertionRelation.AS_CHILD);
    }

    public void moveTo(Node parentNodeProxy, int position) {
        NodeModel parentNode = (NodeModel)((NodeProxy)parentNodeProxy).getDelegate();
        NodeModel movedNode = (NodeModel)this.getDelegate();
        this.getFreeNodeHook().undoableDeactivateHook(movedNode);
        this.getMapController().moveNodes(Arrays.asList(movedNode), parentNode, position);
    }

    public void removeConnector(Connector connectorToBeRemoved) {
        ConnectorProxy connectorProxy = (ConnectorProxy)connectorToBeRemoved;
        ConnectorModel link = connectorProxy.getConnector();
        MLinkController linkController = (MLinkController)this.getLinkController();
        linkController.removeArrowLink(link);
    }

    public void setFolded(boolean folded) {
        NodeModel node = (NodeModel)this.getDelegate();
        this.getMapController().setFolded(node, folded, FilterController.getFilter((MapModel)node.getMap()));
    }

    public void setFree(boolean free) {
        FreeNode freeNode = this.getFreeNodeHook();
        if (free != freeNode.isActive((NodeModel)this.getDelegate())) {
            freeNode.undoableToggleHook((NodeModel)this.getDelegate());
        }
    }

    public void setMinimized(boolean shortened) {
        MTextController textController = (MTextController)this.getTextController();
        textController.setIsMinimized((NodeModel)this.getDelegate(), shortened);
    }

    public void setNote(Object value) {
        this.setNoteText(Convertible.toString(value));
    }

    public void setNoteText(String text) {
        NodeModel delegate = (NodeModel)this.getDelegate();
        MNoteController noteController = (MNoteController)this.getNoteController();
        String noteContentType = noteController.getNoteContentType(delegate);
        noteController.setNoteText(delegate, !HtmlUtils.isHtml((String)text) && TextController.isHtmlContentType((String)noteContentType) ? HtmlUtils.textToHTML((String)text) : text);
    }

    public void setText(Object value) {
        if (value instanceof String) {
            MTextController textController = (MTextController)this.getTextController();
            textController.setNodeText((NodeModel)this.getDelegate(), (String)value);
        } else {
            this.setObject(value);
        }
    }

    public void setObject(Object object) {
        MTextController textController = (MTextController)this.getTextController();
        textController.setNodeObject((NodeModel)this.getDelegate(), ProxyUtils.transformObject(object, null));
    }

    public void setDateTime(Date date) {
        MTextController textController = (MTextController)this.getTextController();
        textController.setNodeObject((NodeModel)this.getDelegate(), (Object)ProxyUtils.createDefaultFormattedDateTime(date));
    }

    public void setBinary(byte[] data) {
        this.setObject(Base64Coding.encode64((byte[])data).replaceAll("(.{74})", "$1\n"));
    }

    public void setFormat(String format) {
        MNodeStyleController styleController = (MNodeStyleController)this.getStyleController();
        styleController.setNodeFormat((NodeModel)this.getDelegate(), format);
    }

    private NodeStyleController getStyleController() {
        return (NodeStyleController)this.getModeController().getExtension(NodeStyleController.class);
    }

    @Deprecated
    public void setLeft(boolean isTopOrLeft) {
        this.setSide(isTopOrLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT);
    }

    public void setSideAtRoot(Side side) {
        this.setSide(NodeModel.Side.values()[side.ordinal()]);
    }

    private void setSide(NodeModel.Side side) {
        this.getMapController().setSide(Collections.singletonList((NodeModel)this.getDelegate()), side);
    }

    public Proxy.Map getMindMap() {
        MapModel map = ((NodeModel)this.getDelegate()).getMap();
        return map != null ? new MapProxy(map, this.getScriptContext()) : null;
    }

    @Override
    @Deprecated
    public List<? extends Node> find(ICondition condition) {
        NodeModel delegate = (NodeModel)this.getDelegate();
        this.reportBranchAccess(delegate);
        return ProxyUtils.find(condition, delegate, this.getScriptContext());
    }

    private void reportBranchAccess(NodeModel delegate) {
        ScriptContext scriptContext = this.getScriptContext();
        if (scriptContext != null) {
            scriptContext.accessBranch(delegate);
        }
    }

    private void reportCloneAccess() {
        ScriptContext scriptContext = this.getScriptContext();
        if (scriptContext != null) {
            scriptContext.accessClones((NodeModel)this.getDelegate());
        }
    }

    @Override
    public List<? extends Node> find(Closure<Boolean> closure) {
        NodeModel delegate = (NodeModel)this.getDelegate();
        this.reportBranchAccess(delegate);
        return ProxyUtils.find(closure, delegate, this.getScriptContext());
    }

    @Override
    public List<? extends Node> find(boolean withAncestors, boolean withDescendants, Closure<Boolean> closure) {
        NodeModel delegate = (NodeModel)this.getDelegate();
        this.reportBranchAccess(delegate);
        return ProxyUtils.find(withAncestors, withDescendants, closure, delegate, this.getScriptContext());
    }

    public List<? extends Node> find(NodeCondition condition) {
        NodeModel delegate = (NodeModel)this.getDelegate();
        this.reportBranchAccess(delegate);
        return ProxyUtils.find(condition, delegate, this.getScriptContext());
    }

    public List<? extends Node> find(boolean withAncestors, boolean withDescendants, NodeCondition condition) {
        NodeModel delegate = (NodeModel)this.getDelegate();
        this.reportBranchAccess(delegate);
        return ProxyUtils.find(withAncestors, withDescendants, condition, delegate, this.getScriptContext());
    }

    public List<? extends Node> findAll() {
        NodeModel delegate = (NodeModel)this.getDelegate();
        this.reportBranchAccess(delegate);
        return ProxyUtils.findAll(delegate, this.getScriptContext(), false);
    }

    public List<? extends Node> findAllDepthFirst() {
        NodeModel delegate = (NodeModel)this.getDelegate();
        this.reportBranchAccess(delegate);
        return ProxyUtils.findAll(delegate, this.getScriptContext(), true);
    }

    public Date getLastModifiedAt() {
        return ((NodeModel)this.getDelegate()).getHistoryInformation().getLastModifiedAt();
    }

    public void setLastModifiedAt(final Date date) {
        final Date oldDate = ((NodeModel)this.getDelegate()).getHistoryInformation().getLastModifiedAt();
        IActor actor = new IActor(){

            public void act() {
                ((NodeModel)NodeProxy.this.getDelegate()).getHistoryInformation().setLastModifiedAt(date);
            }

            public String getDescription() {
                return "setLastModifiedAt";
            }

            public void undo() {
                ((NodeModel)NodeProxy.this.getDelegate()).getHistoryInformation().setLastModifiedAt(oldDate);
            }
        };
        this.getModeController().execute(actor, ((NodeModel)this.getDelegate()).getMap());
    }

    public Date getCreatedAt() {
        return ((NodeModel)this.getDelegate()).getHistoryInformation().getCreatedAt();
    }

    public void setCreatedAt(final Date date) {
        final Date oldDate = ((NodeModel)this.getDelegate()).getHistoryInformation().getCreatedAt();
        IActor actor = new IActor(){

            public void act() {
                ((NodeModel)NodeProxy.this.getDelegate()).getHistoryInformation().setCreatedAt(date);
            }

            public String getDescription() {
                return "setCreatedAt";
            }

            public void undo() {
                ((NodeModel)NodeProxy.this.getDelegate()).getHistoryInformation().setCreatedAt(oldDate);
            }
        };
        this.getModeController().execute(actor, ((NodeModel)this.getDelegate()).getMap());
    }

    public Number and(Number number) {
        return NumberMath.and((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number and(Node node) {
        return NumberMath.and((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number div(Number number) {
        return NumberMath.divide((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number div(Node node) {
        return NumberMath.divide((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number minus(Number number) {
        return NumberMath.subtract((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number minus(Node node) {
        return NumberMath.subtract((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number mod(Number number) {
        return NumberMath.mod((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number mod(Node node) {
        return NumberMath.mod((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number multiply(Number number) {
        return NumberMath.multiply((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number multiply(Node node) {
        return NumberMath.multiply((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number or(Number number) {
        return NumberMath.or((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number or(Node node) {
        return NumberMath.or((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number plus(Number number) {
        return NumberMath.add((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number plus(Node node) {
        return NumberMath.add((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number power(Number number) {
        return DefaultGroovyMethods.power((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number power(Node node) {
        return DefaultGroovyMethods.power((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number xor(Number number) {
        return NumberMath.xor((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number xor(Node node) {
        return NumberMath.xor((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number negative() {
        return NumberMath.subtract((Number)ZERO, (Number)this.getTo().getNum0());
    }

    public Number next() {
        return NumberMath.add((Number)this.getTo().getNum0(), (Number)ONE);
    }

    public Number positive() {
        return this.getTo().getNum0();
    }

    public Number previous() {
        return NumberMath.subtract((Number)this.getTo().getNum0(), (Number)ONE);
    }

    public boolean hasEncryption() {
        return this.getEncryptionModel() != null;
    }

    public boolean isEncrypted() {
        EncryptionModel encryptionModel = this.getEncryptionModel();
        return encryptionModel != null && !encryptionModel.isAccessible();
    }

    private EncryptionModel getEncryptionModel() {
        return EncryptionModel.getModel((NodeModel)((NodeModel)this.getDelegate()));
    }

    public void encrypt(String password) {
        if (!this.isEncrypted()) {
            this.getEncryptionController().toggleLock((NodeModel)this.getDelegate(), this.makePasswordStrategy(password));
        }
    }

    public void decrypt(String password) {
        if (this.isEncrypted()) {
            this.getEncryptionController().toggleLock((NodeModel)this.getDelegate(), this.makePasswordStrategy(password));
        }
    }

    public void removeEncryption(String password) {
        this.getEncryptionController().removeEncryption((NodeModel)this.getDelegate(), this.makePasswordStrategy(password));
    }

    private PasswordStrategy makePasswordStrategy(final String password) {
        return new PasswordStrategy(){

            public StringBuilder getPassword(NodeModel node) {
                return new StringBuilder(password);
            }

            public StringBuilder getPasswordWithConfirmation(NodeModel node) {
                return this.getPassword(node);
            }

            public void onWrongPassword() {
                LogUtils.info((String)("wrong password for node " + NodeProxy.this.getDelegate()));
                NodeProxy.this.setStatusInfo(TextUtils.getText((String)"accessories/plugins/EncryptNode.properties_wrong_password"));
            }

            public boolean isCancelled() {
                return false;
            }
        };
    }

    private void setStatusInfo(String text) {
        ViewController viewController = Controller.getCurrentController().getViewController();
        viewController.out(text);
    }

    public Quantity<LengthUnit> getHorizontalShiftAsLength() {
        return this.getLocationController().getHorizontalShift((NodeModel)this.getDelegate());
    }

    public Quantity<LengthUnit> getVerticalShiftAsLength() {
        return this.getLocationController().getVerticalShift((NodeModel)this.getDelegate());
    }

    public void setHorizontalShift(int horizontalShift) {
        Quantity horizontalShiftQuantity = new Quantity((double)horizontalShift, (Enum)LengthUnit.px);
        ((MLocationController)this.getLocationController()).setHorizontalShift((NodeModel)this.getDelegate(), horizontalShiftQuantity);
    }

    public void setHorizontalShift(Quantity<LengthUnit> verticalShift) {
        ((MLocationController)this.getLocationController()).setHorizontalShift((NodeModel)this.getDelegate(), verticalShift);
    }

    public void setHorizontalShift(String verticalShift) {
        ((MLocationController)this.getLocationController()).setHorizontalShift((NodeModel)this.getDelegate(), Quantity.fromString((String)verticalShift, (Enum)LengthUnit.px));
    }

    public void setVerticalShift(int verticalShift) {
        Quantity verticalShiftQuantity = new Quantity((double)verticalShift, (Enum)LengthUnit.px);
        ((MLocationController)this.getLocationController()).setVerticalShift((NodeModel)this.getDelegate(), verticalShiftQuantity);
    }

    public void setVerticalShift(Quantity<LengthUnit> verticalShift) {
        ((MLocationController)this.getLocationController()).setVerticalShift((NodeModel)this.getDelegate(), verticalShift);
    }

    public void setVerticalShift(String verticalShift) {
        ((MLocationController)this.getLocationController()).setVerticalShift((NodeModel)this.getDelegate(), Quantity.fromString((String)verticalShift, (Enum)LengthUnit.px));
    }

    public Quantity<LengthUnit> getMinimalDistanceBetweenChildrenAsLength() {
        return this.getLocationController().getCommonVGapBetweenChildren((NodeModel)this.getDelegate());
    }

    public Quantity<LengthUnit> getBaseDistanceToChildrenAsLength() {
        return this.getLocationController().getBaseHGapToChildren((NodeModel)this.getDelegate());
    }

    public void setMinimalDistanceBetweenChildren(int minimalDistanceBetweenChildren) {
        Quantity minimalDistanceBetweenChildrenQuantity = new Quantity((double)minimalDistanceBetweenChildren, (Enum)LengthUnit.px);
        ((MLocationController)this.getLocationController()).setCommonVGapBetweenChildren((NodeModel)this.getDelegate(), minimalDistanceBetweenChildrenQuantity);
    }

    public void setBaseDistanceToChildren(int baseDistanceToChildren) {
        Quantity minimalDistanceBetweenChildrenQuantity = new Quantity((double)baseDistanceToChildren, (Enum)LengthUnit.px);
        ((MLocationController)this.getLocationController()).setBaseHGapToChildren((NodeModel)this.getDelegate(), minimalDistanceBetweenChildrenQuantity);
    }

    public void setChildNodesLayout(ChildNodesLayout sides) {
        ((MLayoutController)this.getLayoutController()).setChildNodesLayout((NodeModel)this.getDelegate(), sides);
    }

    public ChildNodesLayout getChildNodesLayout() {
        return this.getLayoutController().getChildNodesLayout((NodeModel)this.getDelegate());
    }

    public LayoutOrientation getLayoutOrientation() {
        return this.getLayoutController().getLayoutOrientation((NodeModel)this.getDelegate());
    }

    public void setMinimalDistanceBetweenChildren(Quantity<LengthUnit> minimalDistanceBetweenChildren) {
        ((MLocationController)this.getLocationController()).setCommonVGapBetweenChildren((NodeModel)this.getDelegate(), minimalDistanceBetweenChildren);
    }

    public void setMinimalDistanceBetweenChildren(String minimalDistanceBetweenChildren) {
        ((MLocationController)this.getLocationController()).setCommonVGapBetweenChildren((NodeModel)this.getDelegate(), Quantity.fromString((String)minimalDistanceBetweenChildren, (Enum)LengthUnit.px));
    }

    public void setBaseDistanceToChildren(Quantity<LengthUnit> baseDistance) {
        ((MLocationController)this.getLocationController()).setBaseHGapToChildren((NodeModel)this.getDelegate(), baseDistance);
    }

    public void setBaseDistanceToChildren(String baseDistance) {
        Quantity baseDistancerenQuantity = Quantity.fromString((String)baseDistance, (Enum)LengthUnit.px);
        ((MLocationController)this.getLocationController()).setBaseHGapToChildren((NodeModel)this.getDelegate(), baseDistancerenQuantity);
    }

    @Override
    public void sortChildrenBy(Closure<Comparable<Object>> closure) {
        Comparator<NodeModel> comparator = this.comparatorByClosureResult(closure);
        this.sortChildrenBy(comparator);
    }

    public void sortChildrenBy(NodeToComparableMapper mapper) {
        Comparator<NodeModel> comparator = this.comparatorByMapper(mapper);
        this.sortChildrenBy(comparator);
    }

    private Comparator<NodeModel> comparatorByMapper(final NodeToComparableMapper mapper) {
        return new Comparator<NodeModel>(){

            @Override
            public int compare(NodeModel o1, NodeModel o2) {
                NodeProxy p1 = new NodeProxy(o1, NodeProxy.this.getScriptContext());
                NodeProxy p2 = new NodeProxy(o1, NodeProxy.this.getScriptContext());
                return mapper.toComparable((NodeRO)p1).compareTo(mapper.toComparable((NodeRO)p2));
            }
        };
    }

    private void sortChildrenBy(Comparator<NodeModel> comparator) {
        this.reportOwnedNodeAccess();
        NodeModel node = (NodeModel)this.getDelegate();
        ArrayList children = new ArrayList(node.getChildren());
        Collections.sort(children, comparator);
        MMapController mapController = (MMapController)this.getModeController().getMapController();
        int i = 0;
        for (NodeModel child : children) {
            this.getFreeNodeHook().undoableDeactivateHook(child);
            mapController.moveNode(child, i++);
        }
    }

    private void reportOwnedNodeAccess() {
        ScriptContext scriptContext = this.getScriptContext();
        if (scriptContext != null) {
            scriptContext.accessNode((NodeModel)this.getDelegate());
        }
    }

    private Comparator<NodeModel> comparatorByClosureResult(final Closure<Comparable<Object>> closure) {
        return new Comparator<NodeModel>(){

            @Override
            public int compare(NodeModel o1, NodeModel o2) {
                NodeProxy p1 = new NodeProxy(o1, NodeProxy.this.getScriptContext());
                NodeProxy p2 = new NodeProxy(o2, NodeProxy.this.getScriptContext());
                return ((Comparable)closure.call((Object)p1)).compareTo(closure.call((Object)p2));
            }
        };
    }

    public int getCountNodesSharingContent() {
        this.reportCloneAccess();
        return ((NodeModel)this.getDelegate()).allClones().size() - 1;
    }

    public int getCountNodesSharingContentAndSubtree() {
        this.reportCloneAccess();
        return ((NodeModel)this.getDelegate()).subtreeClones().size() - 1;
    }

    public List<? extends Node> getNodesSharingContent() {
        this.reportCloneAccess();
        ArrayList<NodeModel> nodeModels = new ArrayList<NodeModel>(((NodeModel)this.getDelegate()).allClones().toCollection());
        nodeModels.remove(this.getDelegate());
        return ProxyUtils.createNodeList(nodeModels, this.getScriptContext());
    }

    public List<? extends Node> getNodesSharingContentAndSubtree() {
        this.reportCloneAccess();
        ArrayList<NodeModel> nodeModels = new ArrayList<NodeModel>(((NodeModel)this.getDelegate()).subtreeClones().toCollection());
        nodeModels.remove(this.getDelegate());
        return ProxyUtils.createNodeList(nodeModels, this.getScriptContext());
    }

    public Node appendAsCloneWithSubtree(NodeRO toBeCloned) {
        return this.appendAsCloneImpl((NodeModel)((NodeProxy)toBeCloned).getDelegate(), true);
    }

    public Node appendAsCloneWithoutSubtree(NodeRO toBeCloned) {
        return this.appendAsCloneImpl((NodeModel)((NodeProxy)toBeCloned).getDelegate(), false);
    }

    private Node appendAsCloneImpl(NodeModel toBeCloned, boolean withSubtree) {
        NodeModel target = (NodeModel)this.getDelegate();
        MMapController mapController = (MMapController)this.getModeController().getMapController();
        if (toBeCloned.getParentNode() == null || toBeCloned.isRoot()) {
            throw new IllegalArgumentException("can't clone root node or node without parent");
        }
        if (!toBeCloned.getMap().equals(((NodeModel)this.getDelegate()).getMap())) {
            throw new IllegalArgumentException("can't clone a node from another map");
        }
        if (toBeCloned.subtreeContainsCloneOf(target)) {
            throw new IllegalArgumentException("can't clone a node which has this node as child");
        }
        NodeModel clone = withSubtree ? toBeCloned.cloneTree() : toBeCloned.cloneContent();
        mapController.addNewNode(clone, target, target.getChildCount());
        return new NodeProxy(clone, this.getScriptContext());
    }

    public void pasteAsClone() {
        MMapClipboardController clipboardController = (MMapClipboardController)this.getClipboardController();
        clipboardController.addClone(clipboardController.getClipboardContents(), (NodeModel)this.getDelegate());
    }

    public Node at(String path) {
        MMapExplorerController explorer = this.getExplorer();
        MapExplorer mapExplorer = explorer.getMapExplorer((NodeModel)this.getDelegate(), path, this.accessedNodes());
        try {
            NodeModel node = mapExplorer.getNode();
            ScriptContext scriptContext = this.getScriptContext();
            return new NodeProxy(node, scriptContext);
        }
        catch (NodeNotFoundException e) {
            throw new org.freeplane.api.NodeNotFoundException((Throwable)e);
        }
    }

    private AccessedNodes accessedNodes() {
        return this.getScriptContext() != null ? this.getScriptContext() : AccessedNodes.IGNORE;
    }

    public List<? extends Node> allAt(String path) {
        MMapExplorerController explorer = this.getExplorer();
        MapExplorer mapExplorer = explorer.getMapExplorer((NodeModel)this.getDelegate(), path, this.accessedNodes());
        ArrayList<NodeModel> nodeModels = new ArrayList<NodeModel>(mapExplorer.getNodes());
        ScriptContext scriptContext = this.getScriptContext();
        return ProxyUtils.createNodeList(nodeModels, scriptContext);
    }

    public String getAlias() {
        MMapExplorerController explorer = this.getExplorer();
        return explorer.getAlias((NodeModel)this.getDelegate());
    }

    public boolean getIsGlobal() {
        MMapExplorerController explorer = this.getExplorer();
        return explorer.isGlobal((NodeModel)this.getDelegate());
    }

    public void setAlias(String alias) {
        MMapExplorerController explorer = this.getExplorer();
        explorer.setAlias((NodeModel)this.getDelegate(), alias);
    }

    public void setIsGlobal(boolean value) {
        MMapExplorerController explorer = this.getExplorer();
        explorer.makeGlobal((NodeModel)this.getDelegate(), value);
    }

    public DependencyLookup getPrecedents() {
        return new DependencyLookupProxy((NodeModel)this.getDelegate(), this.getScriptContext(), DependencySearchStrategy.PRECEDENTS);
    }

    public DependencyLookup getDependents() {
        return new DependencyLookupProxy((NodeModel)this.getDelegate(), this.getScriptContext(), DependencySearchStrategy.DEPENDENTS);
    }

    public NodeGeometry getGeometry() {
        return new NodeGeometryProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    public String getBranchAsTextOutline() {
        return MindMapPlainTextWriter.INSTANCE.getAsPlainText(Collections.singletonList((NodeModel)this.getDelegate()), MapClipboardController.CopiedNodeSet.ALL_NODES);
    }

    public void appendTextOutlineAsBranch(String outline) {
        ((MMapClipboardController)this.getClipboardController()).paste((Transferable)new StringSelection(outline), (NodeModel)this.getDelegate());
    }

    public Tags getTags() {
        return new TagsProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }
}

