import esphome.codegen as cg
from esphome.components import switch
import esphome.config_validation as cv
from esphome.const import (
    CONF_ENTITY_CATEGORY,
    CONF_ICON,
    CONF_ID,
    CONF_INVERTED,
    ENTITY_CATEGORY_CONFIG,
    ICON_RESTART_ALERT,
)

from .. import factory_reset_ns

FactoryResetSwitch = factory_reset_ns.class_(
    "FactoryResetSwitch", switch.Switch, cg.Component
)

CONFIG_SCHEMA = switch.SWITCH_SCHEMA.extend(
    {
        cv.GenerateID(): cv.declare_id(FactoryResetSwitch),
        cv.Optional(CONF_INVERTED): cv.invalid(
            "Factory Reset switches do not support inverted mode!"
        ),
        cv.Optional(CONF_ICON, default=ICON_RESTART_ALERT): cv.icon,
        cv.Optional(
            CONF_ENTITY_CATEGORY, default=ENTITY_CATEGORY_CONFIG
        ): cv.entity_category,
    }
).extend(cv.COMPONENT_SCHEMA)


async def to_code(config):
    var = cg.new_Pvariable(config[CONF_ID])
    await cg.register_component(var, config)
    await switch.register_switch(var, config)
