/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonassert.impl;

import com.jayway.jsonassert.JsonAsserter;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class JsonAsserterImpl
implements JsonAsserter {
    private final Object jsonObject;

    public JsonAsserterImpl(Object jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public <T> JsonAsserter assertThat(String path, Matcher<T> matcher) {
        Object obj = null;
        try {
            obj = JsonPath.read((Object)this.jsonObject, (String)path, (Predicate[])new Predicate[0]);
        }
        catch (Exception e) {
            AssertionError assertionError = new AssertionError((Object)String.format("Error reading JSON path [%s]", path));
            ((Throwable)((Object)assertionError)).initCause(e);
            throw assertionError;
        }
        if (!matcher.matches(obj)) {
            throw new AssertionError((Object)String.format("JSON path [%s] doesn't match.\nExpected:\n%s\nActual:\n%s", path, matcher.toString(), obj));
        }
        return this;
    }

    @Override
    public <T> JsonAsserter assertThat(String path, Matcher<T> matcher, String message) {
        Object obj = JsonPath.read((Object)this.jsonObject, (String)path, (Predicate[])new Predicate[0]);
        if (!matcher.matches(obj)) {
            throw new AssertionError((Object)String.format("JSON Assert Error: %s\nExpected:\n%s\nActual:\n%s", message, matcher.toString(), obj));
        }
        return this;
    }

    @Override
    public <T> JsonAsserter assertEquals(String path, T expected) {
        return this.assertThat(path, Matchers.equalTo(expected));
    }

    @Override
    public JsonAsserter assertNotDefined(String path) {
        try {
            Configuration c = Configuration.defaultConfiguration();
            JsonPath.using((Configuration)c).parse(this.jsonObject).read(path, new Predicate[0]);
            throw new AssertionError((Object)String.format("Document contains the path <%s> but was expected not to.", path));
        }
        catch (PathNotFoundException pathNotFoundException) {
            return this;
        }
    }

    @Override
    public JsonAsserter assertNotDefined(String path, String message) {
        try {
            Configuration c = Configuration.defaultConfiguration();
            JsonPath.using((Configuration)c).parse(this.jsonObject).read(path, new Predicate[0]);
            throw new AssertionError((Object)String.format("Document contains the path <%s> but was expected not to.", path));
        }
        catch (PathNotFoundException pathNotFoundException) {
            return this;
        }
    }

    @Override
    public JsonAsserter assertNull(String path) {
        return this.assertThat(path, Matchers.nullValue());
    }

    @Override
    public JsonAsserter assertNull(String path, String message) {
        return this.assertThat(path, Matchers.nullValue(), message);
    }

    @Override
    public <T> JsonAsserter assertEquals(String path, T expected, String message) {
        return this.assertThat(path, Matchers.equalTo(expected), message);
    }

    @Override
    public <T> JsonAsserter assertNotNull(String path) {
        return this.assertThat(path, Matchers.notNullValue());
    }

    @Override
    public <T> JsonAsserter assertNotNull(String path, String message) {
        return this.assertThat(path, Matchers.notNullValue(), message);
    }

    @Override
    public JsonAsserter and() {
        return this;
    }
}

