# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class CertificateInfoObject(_model_base.Model):
    """The Security Domain download operation requires customer to provide N certificates (minimum 3
    and maximum 10)
    containing a public key in JWK format.

    All required parameters must be populated in order to send to server.

    :ivar certificates: Certificates needed from customer. Required.
    :vartype certificates: list[~azure.keyvault.securitydomain.models.SecurityDomainJsonWebKey]
    :ivar required: Customer to specify the number of certificates (minimum 2 and maximum 10) to
     restore Security Domain.
    :vartype required: int
    """

    certificates: List["_models.SecurityDomainJsonWebKey"] = rest_field()
    """Certificates needed from customer. Required."""
    required: Optional[int] = rest_field()
    """Customer to specify the number of certificates (minimum 2 and maximum 10) to restore Security
     Domain."""

    @overload
    def __init__(
        self,
        *,
        certificates: List["_models.SecurityDomainJsonWebKey"],
        required: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SecurityDomainJsonWebKey(_model_base.Model):
    """A JSON Web Key (JWK) for use in a security domain operation.


    :ivar kid: Key identifier. Required.
    :vartype kid: str
    :ivar kty: JsonWebKey Key Type (kty), as defined in
     https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40. For
     Security Domain this value must be RSA. Required.
    :vartype kty: str
    :ivar key_ops: Supported key operations. Required.
    :vartype key_ops: list[str]
    :ivar n: RSA modulus. Required.
    :vartype n: str
    :ivar e: RSA public exponent. Required.
    :vartype e: str
    :ivar x5_c: X509 certificate chain parameter. Required.
    :vartype x5_c: list[str]
    :ivar use: Public Key Use Parameter. This is optional and if present must be enc.
    :vartype use: str
    :ivar x5_t: X509 certificate SHA1 thumbprint. This is optional.
    :vartype x5_t: str
    :ivar x5_t_s256: X509 certificate SHA256 thumbprint. Required.
    :vartype x5_t_s256: str
    :ivar alg: Algorithm intended for use with the key. Required.
    :vartype alg: str
    """

    kid: str = rest_field()
    """Key identifier. Required."""
    kty: str = rest_field()
    """JsonWebKey Key Type (kty), as defined in
     https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40. For
     Security Domain this value must be RSA. Required."""
    key_ops: List[str] = rest_field()
    """Supported key operations. Required."""
    n: str = rest_field()
    """RSA modulus. Required."""
    e: str = rest_field()
    """RSA public exponent. Required."""
    x5_c: List[str] = rest_field(name="x5c")
    """X509 certificate chain parameter. Required."""
    use: Optional[str] = rest_field()
    """Public Key Use Parameter. This is optional and if present must be enc."""
    x5_t: Optional[str] = rest_field(name="x5t")
    """X509 certificate SHA1 thumbprint. This is optional."""
    x5_t_s256: str = rest_field(name="x5t#S256")
    """X509 certificate SHA256 thumbprint. Required."""
    alg: str = rest_field()
    """Algorithm intended for use with the key. Required."""

    @overload
    def __init__(
        self,
        *,
        kid: str,
        kty: str,
        key_ops: List[str],
        n: str,
        e: str,
        x5_c: List[str],
        x5_t_s256: str,
        alg: str,
        use: Optional[str] = None,
        x5_t: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SecurityDomainObject(_model_base.Model):
    """The Security Domain.


    :ivar value: The Security Domain. Required.
    :vartype value: str
    """

    value: str = rest_field()
    """The Security Domain. Required."""

    @overload
    def __init__(
        self,
        *,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SecurityDomainOperationStatus(_model_base.Model):
    """The Security Domain operation status.

    :ivar status: Operation status. Known values are: "Success", "InProgress", and "Failed".
    :vartype status: str or ~azure.keyvault.securitydomain.models.OperationStatus
    :ivar status_details: Details of the operation status.
    :vartype status_details: str
    """

    status: Optional[Union[str, "_models.OperationStatus"]] = rest_field()
    """Operation status. Known values are: \"Success\", \"InProgress\", and \"Failed\"."""
    status_details: Optional[str] = rest_field()
    """Details of the operation status."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.OperationStatus"]] = None,
        status_details: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TransferKey(_model_base.Model):
    """Security Domain transfer key.


    :ivar key_format: Specifies the format of the transfer key.
    :vartype key_format: str
    :ivar transfer_key_jwk: Specifies the transfer key in JWK format. Required.
    :vartype transfer_key_jwk: ~azure.keyvault.securitydomain.models.SecurityDomainJsonWebKey
    """

    key_format: Optional[str] = rest_field()
    """Specifies the format of the transfer key."""
    transfer_key_jwk: "_models.SecurityDomainJsonWebKey" = rest_field(name="transfer_key")
    """Specifies the transfer key in JWK format. Required."""

    @overload
    def __init__(
        self,
        *,
        transfer_key_jwk: "_models.SecurityDomainJsonWebKey",
        key_format: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
