/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.stream.BiJoinStream;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class LeftOuterJoinStream
extends BiJoinStream
implements Expressible {
    private final LinkedList<Tuple> joinedTuples = new LinkedList();
    private final LinkedList<Tuple> leftTupleGroup = new LinkedList();
    private final LinkedList<Tuple> rightTupleGroup = new LinkedList();

    public LeftOuterJoinStream(TupleStream leftStream, TupleStream rightStream, StreamEqualitor eq) throws IOException {
        super(leftStream, rightStream, eq);
    }

    public LeftOuterJoinStream(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Tuple read() throws IOException {
        if (this.joinedTuples.size() > 0) {
            return this.joinedTuples.removeFirst();
        }
        while (true) {
            if (0 == this.leftTupleGroup.size()) {
                Tuple firstMember = this.loadEqualTupleGroup(this.leftStream, this.leftTupleGroup, this.leftStreamComparator);
                if (firstMember.EOF) {
                    return firstMember;
                }
            }
            if (0 == this.rightTupleGroup.size()) {
                this.loadEqualTupleGroup(this.rightStream, this.rightTupleGroup, this.rightStreamComparator);
            }
            if (0 == this.rightTupleGroup.size() || this.rightTupleGroup.get((int)0).EOF) {
                return this.leftTupleGroup.removeFirst();
            }
            if (this.eq.test(this.leftTupleGroup.get(0), this.rightTupleGroup.get(0))) {
                for (Tuple left : this.leftTupleGroup) {
                    for (Tuple right : this.rightTupleGroup) {
                        Tuple clone = left.clone();
                        clone.merge(right);
                        this.joinedTuples.add(clone);
                    }
                }
                this.leftTupleGroup.clear();
                this.rightTupleGroup.clear();
                return this.joinedTuples.removeFirst();
            }
            int c = this.iterationComparator.compare(this.leftTupleGroup.get(0), this.rightTupleGroup.get(0));
            if (c < 0) {
                return this.leftTupleGroup.removeFirst();
            }
            this.rightTupleGroup.clear();
        }
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.iterationComparator;
    }
}

