/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.attrs;

import java.util.List;
import org.carrot2.attrs.Attr;
import org.carrot2.attrs.Constraint;

public class AttrInteger
extends Attr<Integer> {
    private AttrInteger(Integer value, List<? extends Constraint<? super Integer>> constraint, String label) {
        super(value, label, constraint);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Attr.BuilderScaffold<Integer> {
        public Builder min(int minInclusive) {
            this.addConstraint(Constraint.named("value >= " + minInclusive, v -> {
                if (v != null && v < minInclusive) {
                    throw new IllegalArgumentException("Value must be >= " + minInclusive + ": " + v);
                }
            }));
            return this;
        }

        public Builder max(int maxInclusive) {
            this.addConstraint(Constraint.named("value <= " + maxInclusive, v -> {
                if (v != null && v > maxInclusive) {
                    throw new IllegalArgumentException("Value must be <= " + maxInclusive + ": " + v);
                }
            }));
            return this;
        }

        public Builder label(String label) {
            super.label(label);
            return this;
        }

        public AttrInteger defaultValue(Integer defaultValue) {
            return new AttrInteger(defaultValue, this.getConstraint(), this.label);
        }
    }
}

