/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.facet.CountAgg;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessor;
import org.apache.solr.search.facet.SlotAcc;

class FacetFieldProcessorByEnumTermsStream
extends FacetFieldProcessor
implements Closeable {
    long effectiveLimit;
    long bucketsToSkip;
    long bucketsReturned;
    boolean closed;
    boolean countOnly;
    boolean hasSubFacets;
    int minDfFilterCache;
    DocSet docs;
    Bits fastForRandomSet;
    TermsEnum termsEnum = null;
    SolrIndexSearcher.DocsEnumState deState = null;
    PostingsEnum postingsEnum;
    BytesRef startTermBytes;
    BytesRef term;
    AtomicBoolean shardHasMoreBuckets = new AtomicBoolean(false);
    private IntFunction<SlotAcc.SlotContext> slotContext = slotNum -> {
        assert (null != this.term);
        return new SlotAcc.SlotContext((Query)new TermQuery(new Term(this.sf.getName(), this.term)));
    };
    LeafReaderContext[] leaves;

    FacetFieldProcessorByEnumTermsStream(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq, sf);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
        }
    }

    @Override
    public void process() throws IOException {
        super.process();
        this.fcontext.qcontext.addCloseHook(this);
        this.setup();
        this.response = new SimpleOrderedMap();
        this.response.add("buckets", (Object)new Iterator<Object>(){
            boolean retrieveNext = true;
            Object val;

            @Override
            public boolean hasNext() {
                if (this.retrieveNext) {
                    this.val = FacetFieldProcessorByEnumTermsStream.this.nextBucket();
                }
                this.retrieveNext = false;
                return this.val != null;
            }

            @Override
            public Object next() {
                if (this.retrieveNext) {
                    this.val = FacetFieldProcessorByEnumTermsStream.this.nextBucket();
                }
                this.retrieveNext = true;
                if (this.val == null) {
                    boolean removed = FacetFieldProcessorByEnumTermsStream.this.fcontext.qcontext.removeCloseHook(FacetFieldProcessorByEnumTermsStream.this);
                    assert (removed);
                    try {
                        FacetFieldProcessorByEnumTermsStream.this.close();
                    }
                    catch (IOException e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error during facet streaming close", (Throwable)e);
                    }
                }
                return this.val;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
        if (this.fcontext.isShard()) {
            this.response.add("more", (Object)this.shardHasMoreBuckets);
        }
    }

    private void setup() throws IOException {
        String triePrefix;
        this.countOnly = ((FacetField)this.freq).facetStats.size() == 0 || ((FacetField)this.freq).facetStats.values().iterator().next() instanceof CountAgg;
        this.hasSubFacets = ((FacetField)this.freq).subFacets.size() > 0;
        this.bucketsToSkip = ((FacetField)this.freq).offset;
        this.effectiveLimit = ((FacetField)this.freq).limit;
        if (((FacetField)this.freq).limit >= 0L) {
            if (((FacetField)this.freq).overrequest < -1) {
                throw new IllegalArgumentException("Illegal `overrequest` specified: " + ((FacetField)this.freq).overrequest);
            }
            if (((FacetField)this.freq).overrequest > 0 && (this.fcontext.isShard() || null != this.resort)) {
                this.effectiveLimit += (long)((FacetField)this.freq).overrequest;
            }
        }
        this.createAccs(-1L, 1);
        this.minDfFilterCache = ((FacetField)this.freq).cacheDf == -1 ? Integer.MAX_VALUE : (((FacetField)this.freq).cacheDf == 0 ? Math.max(this.fcontext.searcher.maxDoc() >> 4, 3) : ((FacetField)this.freq).cacheDf);
        this.docs = this.fcontext.base;
        this.fastForRandomSet = null;
        if (((FacetField)this.freq).prefix != null) {
            String indexedPrefix = this.sf.getType().toInternal(((FacetField)this.freq).prefix);
            this.startTermBytes = new BytesRef((CharSequence)indexedPrefix);
        } else if (this.sf.getType().getNumberType() != null && (triePrefix = TrieField.getMainValuePrefix(this.sf.getType())) != null) {
            this.startTermBytes = new BytesRef((CharSequence)triePrefix);
        }
        Terms terms = this.fcontext.searcher.getSlowAtomicReader().terms(this.sf.getName());
        this.termsEnum = null;
        this.deState = null;
        this.term = null;
        if (terms != null) {
            this.termsEnum = terms.iterator();
            if (this.startTermBytes != null) {
                if (this.termsEnum.seekCeil(this.startTermBytes) == TermsEnum.SeekStatus.END) {
                    this.termsEnum = null;
                } else {
                    this.term = this.termsEnum.term();
                }
            } else {
                this.term = this.termsEnum.next();
            }
        }
        List leafList = this.fcontext.searcher.getTopReaderContext().leaves();
        this.leaves = leafList.toArray(new LeafReaderContext[0]);
    }

    private SimpleOrderedMap<Object> nextBucket() {
        try {
            return this._nextBucket();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error during facet streaming", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleOrderedMap<Object> _nextBucket() throws IOException {
        DocSet termSet = null;
        try {
            while (this.term != null) {
                if (this.startTermBytes != null && !StringHelper.startsWith((BytesRef)this.term, (BytesRef)this.startTermBytes)) {
                    break;
                }
                int df = this.termsEnum.docFreq();
                if (df < this.effectiveMincount) {
                    this.term = this.termsEnum.next();
                    continue;
                }
                if (termSet != null) {
                    termSet = null;
                }
                int c = 0;
                if (this.hasSubFacets || df >= this.minDfFilterCache) {
                    if (this.deState == null) {
                        this.deState = new SolrIndexSearcher.DocsEnumState();
                        this.deState.fieldName = this.sf.getName();
                        this.deState.liveDocs = this.fcontext.searcher.getLiveDocsBits();
                        this.deState.termsEnum = this.termsEnum;
                        this.deState.postingsEnum = this.postingsEnum;
                        this.deState.minSetSizeCached = this.minDfFilterCache;
                    }
                    if (this.hasSubFacets || !this.countOnly) {
                        DocSet termsAll = this.fcontext.searcher.getDocSet(this.deState);
                        termSet = this.docs.intersection(termsAll);
                        c = termSet.size();
                    } else {
                        c = this.fcontext.searcher.numDocs(this.docs, this.deState);
                    }
                    this.postingsEnum = this.deState.postingsEnum;
                    this.resetStats();
                    if (!this.countOnly) {
                        this.collect(termSet, 0, this.slotContext);
                    }
                } else {
                    this.resetStats();
                    if (this.fastForRandomSet == null) {
                        this.fastForRandomSet = this.docs.getBits();
                    }
                    this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
                    if (this.postingsEnum instanceof MultiPostingsEnum) {
                        MultiPostingsEnum.EnumWithSlice[] subs = ((MultiPostingsEnum)this.postingsEnum).getSubs();
                        int numSubs = ((MultiPostingsEnum)this.postingsEnum).getNumSubs();
                        for (int subindex = 0; subindex < numSubs; ++subindex) {
                            int docid;
                            MultiPostingsEnum.EnumWithSlice sub = subs[subindex];
                            if (sub.postingsEnum == null) continue;
                            int base = sub.slice.start;
                            if (this.countOnly) {
                                while ((docid = sub.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                    if (!this.fastForRandomSet.get(docid + base)) continue;
                                    ++c;
                                }
                                continue;
                            }
                            this.setNextReader(this.leaves[sub.slice.readerIndex]);
                            while ((docid = sub.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                if (!this.fastForRandomSet.get(docid + base)) continue;
                                ++c;
                                this.collect(docid, 0, this.slotContext);
                            }
                        }
                    } else if (this.countOnly) {
                        int docid;
                        while ((docid = this.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                            if (!this.fastForRandomSet.get(docid)) continue;
                            ++c;
                        }
                    } else {
                        int docid;
                        this.setNextReader(this.leaves[0]);
                        while ((docid = this.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                            if (!this.fastForRandomSet.get(docid)) continue;
                            ++c;
                            this.collect(docid, 0, this.slotContext);
                        }
                    }
                }
                if (c < this.effectiveMincount) {
                    this.term = this.termsEnum.next();
                    continue;
                }
                if (this.bucketsToSkip > 0L) {
                    --this.bucketsToSkip;
                    this.term = this.termsEnum.next();
                    continue;
                }
                if (this.effectiveLimit >= 0L && ++this.bucketsReturned > this.effectiveLimit) {
                    this.shardHasMoreBuckets.set(true);
                    SimpleOrderedMap<Object> docid = null;
                    return docid;
                }
                this.countAcc.incrementCount(0, c);
                Object bucketVal = this.sf.getType().toObject(this.sf, this.term);
                TermQuery bucketQuery = this.hasSubFacets ? new TermQuery(new Term(((FacetField)this.freq).field, this.term)) : null;
                this.term = this.termsEnum.next();
                SimpleOrderedMap bucket = new SimpleOrderedMap();
                bucket.add("val", bucketVal);
                this.addStats((SimpleOrderedMap<Object>)bucket, 0);
                if (this.hasSubFacets) {
                    this.processSubs((SimpleOrderedMap<Object>)bucket, (Query)bucketQuery, termSet, false, null);
                }
                SimpleOrderedMap simpleOrderedMap = bucket;
                return simpleOrderedMap;
            }
        }
        finally {
            if (termSet != null) {
                termSet = null;
            }
        }
        return null;
    }
}

