/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import org.apache.sis.internal.util.Acyclic;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.internal.util.PropertyFormat;
import org.apache.sis.internal.util.TreeFormatCustomization;
import org.apache.sis.io.LineAppender;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;

public class TreeTableFormat
extends TabularFormat<TreeTable> {
    private static final long serialVersionUID = 147992015470098561L;
    static final TreeTableFormat INSTANCE = new TreeTableFormat(null, null);
    private Map<TableColumn<?>, Integer> columnIndices;
    private int indentation = 4;
    private int verticalLinePosition = 2;
    private transient String treeBlank;
    private transient String treeLine;
    private transient String treeCross;
    private transient String treeEnd;
    private Predicate<TreeTable.Node> nodeFilter;
    private transient Set<TreeTable.Node> recursivityGuard;
    private transient DecimalFormat adaptableFormat;
    private transient String defaultPattern;
    private transient boolean usingScientificNotation;

    public TreeTableFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
        this.beforeFill = "\u2026\u2026";
        this.fillCharacter = (char)8230;
        this.omitTrailingNulls = true;
    }

    private void clearTreeSymbols() {
        this.treeBlank = null;
        this.treeLine = null;
        this.treeCross = null;
        this.treeEnd = null;
    }

    @Override
    public final Class<TreeTable> getValueType() {
        return TreeTable.class;
    }

    public TableColumn<?>[] getColumns() {
        return this.columnIndices != null ? DefaultTreeTable.getColumns(this.columnIndices) : null;
    }

    public void setColumns(TableColumn<?> ... tableColumnArray) throws IllegalArgumentException {
        if (tableColumnArray == null) {
            this.columnIndices = null;
        } else {
            ArgumentChecks.ensureNonEmpty("columns", tableColumnArray);
            this.columnIndices = DefaultTreeTable.createColumnIndices(tableColumnArray);
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int n) throws IllegalArgumentException {
        ArgumentChecks.ensurePositive("indentation", n);
        this.indentation = n;
        if (this.verticalLinePosition > n) {
            this.verticalLinePosition = n;
        }
        this.clearTreeSymbols();
    }

    public int getVerticalLinePosition() {
        return this.verticalLinePosition;
    }

    public void setVerticalLinePosition(int n) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween("verticalLinePosition", 0, this.indentation, n);
        this.verticalLinePosition = n;
        this.clearTreeSymbols();
    }

    public Predicate<TreeTable.Node> getNodeFilter() {
        return this.nodeFilter;
    }

    public void setNodeFilter(Predicate<TreeTable.Node> predicate) {
        this.nodeFilter = predicate;
    }

    private Locale getDisplayLocale() {
        return this.getLocale(Locale.Category.DISPLAY);
    }

    final Format[] getFormats(TableColumn<?>[] tableColumnArray, boolean bl) throws IllegalStateException {
        Format[] formatArray = new Format[tableColumnArray.length];
        for (int i = 0; i < formatArray.length; ++i) {
            Class<String> clazz = tableColumnArray[i].getElementType();
            formatArray[i] = this.getFormat(clazz);
            if (formatArray[i] != null || !bl || clazz.isAssignableFrom(String.class)) continue;
            throw new IllegalStateException(Errors.format((short)158, clazz));
        }
        return formatArray;
    }

    @Override
    public TreeTable parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        int n;
        Matcher matcher = this.getColumnSeparatorMatcher(charSequence);
        int n2 = charSequence.length();
        int n3 = parsePosition.getIndex();
        int n4 = 0;
        int[] nArray = new int[16];
        TreeTable.Node node = null;
        DefaultTreeTable.Node node2 = null;
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(this.columnIndices != null ? this.columnIndices : TableColumn.NAME_MAP);
        TableColumn<?>[] tableColumnArray = DefaultTreeTable.getColumns(defaultTreeTable.columnIndices);
        Format[] formatArray = this.getFormats(tableColumnArray, true);
        do {
            int n5;
            int n6;
            int n7;
            char c;
            int n8;
            for (n8 = n = CharSequences.indexOfLineStart(charSequence, 1, n3); n8 > n3 && ((c = charSequence.charAt(n8 - 1)) == '\r' || c == '\n'); --n8) {
            }
            c = '\u0000';
            for (n6 = n3; n6 < n8; n6 += Character.charCount(n7)) {
                n7 = Character.codePointAt(charSequence, n6);
                if (Character.isSpaceChar(n7)) continue;
                c = '\u0001';
                if ("\u2500\u2502\u2514\u251c".indexOf(n7) < 0) break;
            }
            if (c == '\u0000') break;
            n7 = n6;
            n6 = CharSequences.skipTrailingWhitespaces(charSequence, n3, n6) - n3;
            DefaultTreeTable.Node node3 = new DefaultTreeTable.Node(defaultTreeTable);
            matcher.region(n7, n8);
            for (n5 = 0; n5 < tableColumnArray.length; ++n5) {
                boolean bl = matcher.find();
                int n9 = bl ? matcher.start() : n8;
                int n10 = CharSequences.skipTrailingWhitespaces(charSequence, n7 = CharSequences.skipLeadingWhitespaces(charSequence, n7, n9), n9);
                if (n10 > n7) {
                    String string = charSequence.subSequence(n7, n10).toString();
                    try {
                        this.parseValue(node3, tableColumnArray[n5], formatArray[n5], string);
                    }
                    catch (ClassCastException | ParseException exception) {
                        parsePosition.setErrorIndex(n7);
                        if (exception instanceof ParseException) {
                            n7 += ((ParseException)exception).getErrorOffset();
                        }
                        throw new LocalizedParseException(this.getDisplayLocale(), 154, new Object[]{tableColumnArray[n5].getElementType(), string}, n7).initCause(exception);
                    }
                }
                if (!bl) break;
                n7 = matcher.end();
            }
            if (node2 == null) {
                nArray[0] = n6;
                node2 = node3;
            } else {
                while (n6 < (n5 = nArray[n4])) {
                    if (--n4 < 0) {
                        parsePosition.setErrorIndex(n3);
                        throw new LocalizedParseException(this.getDisplayLocale(), 98, new Object[]{node3}, n3);
                    }
                    node = node.getParent();
                }
                if (n6 == n5) {
                    TreeTable.Node node4 = node.getParent();
                    if (node4 == null) {
                        parsePosition.setErrorIndex(n3);
                        throw new LocalizedParseException(this.getDisplayLocale(), 98, new Object[]{node3}, n3);
                    }
                    node4.getChildren().add(node3);
                } else if (n6 > n5) {
                    node.getChildren().add(node3);
                    if (++n4 == nArray.length) {
                        nArray = Arrays.copyOf(nArray, n4 * 2);
                    }
                    nArray[n4] = n6;
                }
            }
            node = node3;
        } while ((n3 = n) != n2);
        if (node2 == null) {
            return null;
        }
        parsePosition.setIndex(n3);
        defaultTreeTable.setRoot(node2);
        return defaultTreeTable;
    }

    private <V> void parseValue(TreeTable.Node node, TableColumn<V> tableColumn, Format format, String string) throws ParseException {
        Object object = format != null ? format.parseObject(string) : string;
        node.setValue(tableColumn, tableColumn.getElementType().cast(object));
    }

    private void createTreeSymbols() {
        int n = this.indentation;
        int n2 = this.verticalLinePosition;
        char[] cArray = new char[n];
        block6: for (int i = 0; i < 4; ++i) {
            char c;
            int n3;
            if ((i & 2) == 0) {
                n3 = (i & 1) == 0 ? 160 : 9474;
                c = '\u00a0';
            } else {
                n3 = (i & 1) == 0 ? 9492 : 9500;
                c = '\u2500';
            }
            Arrays.fill(cArray, 0, n2, '\u00a0');
            cArray[n2] = n3;
            Arrays.fill(cArray, n2 + 1, n, c);
            String string = String.valueOf(cArray);
            switch (i) {
                case 0: {
                    this.treeBlank = string;
                    continue block6;
                }
                case 1: {
                    this.treeLine = string;
                    continue block6;
                }
                case 2: {
                    this.treeEnd = string;
                    continue block6;
                }
                case 3: {
                    this.treeCross = string;
                    continue block6;
                }
                default: {
                    throw new AssertionError(i);
                }
            }
        }
    }

    final String getTreeSymbols(boolean bl, boolean bl2) {
        return bl ? (bl2 ? this.treeBlank : this.treeLine) : (bl2 ? this.treeEnd : this.treeCross);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(TreeTable treeTable, Appendable appendable) throws IOException {
        Object object;
        TableColumn<?>[] tableColumnArray;
        ArgumentChecks.ensureNonNull("tree", treeTable);
        if (this.treeBlank == null) {
            this.createTreeSymbols();
        }
        if (this.columnIndices != null) {
            tableColumnArray = DefaultTreeTable.getColumns(this.columnIndices);
        } else {
            object = treeTable.getColumns();
            tableColumnArray = object.toArray(new TableColumn[object.size()]);
        }
        if (this.recursivityGuard == null) {
            this.recursivityGuard = new HashSet<TreeTable.Node>();
        }
        try {
            object = new Writer(appendable, treeTable, tableColumnArray, this.recursivityGuard);
            ((Writer)object).format(treeTable.getRoot(), 0);
            ((LineAppender)object).flush();
        }
        finally {
            this.recursivityGuard.clear();
        }
    }

    @Override
    protected Format createFormat(Class<?> clazz) {
        Format format = super.createFormat(clazz);
        if (format instanceof UnitFormat) {
            ((UnitFormat)format).setStyle(UnitFormat.Style.NAME);
        }
        return format;
    }

    protected void writeColumnSeparator(int n, TableAppender tableAppender) {
        tableAppender.append(this.beforeFill);
        tableAppender.nextColumn(this.fillCharacter);
        tableAppender.append(this.columnSeparator);
    }

    @Override
    public TreeTableFormat clone() {
        TreeTableFormat treeTableFormat = (TreeTableFormat)super.clone();
        treeTableFormat.recursivityGuard = null;
        return treeTableFormat;
    }

    private final class Writer
    extends PropertyFormat {
        private final Predicate<TreeTable.Node> filter;
        private final TableColumn<?>[] columns;
        private final Format[] formats;
        private final Object[] values;
        private boolean[] isLast;
        private final boolean multiLineCells;
        private final Set<TreeTable.Node> recursivityGuard;

        Writer(Appendable appendable, TreeTable treeTable, TableColumn<?>[] tableColumnArray, Set<TreeTable.Node> set) {
            TreeFormatCustomization treeFormatCustomization;
            Predicate<TreeTable.Node> predicate;
            super(tableColumnArray.length >= 2 ? new TableAppender(appendable, "") : appendable);
            this.multiLineCells = this.out == appendable;
            this.columns = tableColumnArray;
            this.formats = TreeTableFormat.this.getFormats(tableColumnArray, false);
            this.values = new Object[tableColumnArray.length];
            this.isLast = new boolean[8];
            this.recursivityGuard = set;
            Predicate<TreeTable.Node> predicate2 = TreeTableFormat.this.nodeFilter;
            if (treeTable instanceof TreeFormatCustomization && (predicate = (treeFormatCustomization = (TreeFormatCustomization)((Object)treeTable)).filter()) != null) {
                predicate2 = predicate2 != null ? predicate.and(predicate2) : predicate;
            }
            this.filter = predicate2;
            this.setTabulationExpanded(true);
            this.setLineSeparator(this.multiLineCells ? TreeTableFormat.this.getLineSeparator() : " \u00b6 ");
        }

        @Override
        public Locale getLocale() {
            return TreeTableFormat.this.getLocale();
        }

        @Override
        protected final String toString(Object object) {
            String string;
            Format format = TreeTableFormat.this.getFormat(object.getClass());
            if (format instanceof DecimalFormat && Numbers.isFloat(object.getClass())) {
                double d = ((Number)object).doubleValue();
                if (d != (double)((int)d)) {
                    int n;
                    boolean bl;
                    if (TreeTableFormat.this.adaptableFormat == null) {
                        TreeTableFormat.this.adaptableFormat = (DecimalFormat)format.clone();
                        TreeTableFormat.this.defaultPattern = TreeTableFormat.this.adaptableFormat.toPattern();
                    }
                    boolean bl2 = bl = (n = DecimalFunctions.fractionDigitsForValue(d)) > 20 || n < 7;
                    if (bl != TreeTableFormat.this.usingScientificNotation) {
                        TreeTableFormat.this.usingScientificNotation = bl;
                        TreeTableFormat.this.adaptableFormat.applyPattern(bl ? "0.0############E0" : TreeTableFormat.this.defaultPattern);
                    }
                    if (!bl) {
                        TreeTableFormat.this.adaptableFormat.setMaximumFractionDigits(n - 2);
                    }
                    string = TreeTableFormat.this.adaptableFormat.format(object);
                } else {
                    string = format.format(object);
                }
            } else {
                string = format != null ? format.format(object) : object.toString();
            }
            return string;
        }

        final void format(TreeTable.Node node, int n) throws IOException {
            int n2;
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                this.out.append(TreeTableFormat.this.getTreeSymbols(n3 != n - 1, this.isLast[n3]));
            }
            for (n3 = 0; n3 < this.columns.length; ++n3) {
                this.values[n3] = node.getValue(this.columns[n3]);
            }
            if (TreeTableFormat.this.omitTrailingNulls) {
                for (n3 = this.values.length - 1; n3 > 0 && this.values[n3] == null; --n3) {
                }
            }
            for (n2 = 0; n2 <= n3; ++n2) {
                if (n2 != 0) {
                    TreeTableFormat.this.writeColumnSeparator(n2, (TableAppender)this.out);
                }
                this.columnFormat = this.formats[n2];
                this.appendValue(this.values[n2]);
                this.clear();
            }
            this.out.append(TreeTableFormat.this.lineSeparator);
            if (n >= this.isLast.length) {
                this.isLast = Arrays.copyOf(this.isLast, n * 2);
            }
            if ((n2 = (int)(node.getClass().isAnnotationPresent(Acyclic.class) ? 1 : 0)) != 0 || this.recursivityGuard.add(node)) {
                boolean bl = this.multiLineCells;
                String string = bl ? this.getLineSeparator() : null;
                Iterator<TreeTable.Node> iterator = node.getChildren().iterator();
                TreeTable.Node node2 = this.next(iterator);
                while (node2 != null) {
                    TreeTable.Node node3 = node2;
                    node2 = this.next(iterator);
                    this.isLast[n] = node2 == null;
                    if ((bl |= this.isLast[n]) && string != null) {
                        this.setLineSeparator(string + TreeTableFormat.this.getTreeSymbols(true, this.isLast[n]));
                    }
                    this.format(node3, n + 1);
                }
                if (string != null) {
                    this.setLineSeparator(string);
                }
                if (n2 == 0 && !this.recursivityGuard.remove(node)) {
                    throw new ConcurrentModificationException();
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.out.append(TreeTableFormat.this.getTreeSymbols(true, this.isLast[i]));
                }
                Locale locale = TreeTableFormat.this.getDisplayLocale();
                this.out.append(TreeTableFormat.this.treeBlank).append('(').append(Vocabulary.getResources(locale).getString((short)46).toLowerCase(locale)).append(')').append(TreeTableFormat.this.lineSeparator);
            }
        }

        private TreeTable.Node next(Iterator<? extends TreeTable.Node> iterator) {
            while (iterator.hasNext()) {
                TreeTable.Node node = iterator.next();
                if (node == null || this.filter != null && !this.filter.test(node)) continue;
                return node;
            }
            return null;
        }
    }
}

