/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.feature.FeatureException;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class SolrFeature
extends Feature {
    private String df;
    private String q;
    private List<String> fq;

    public String getDf() {
        return this.df;
    }

    public void setDf(String df) {
        this.df = df;
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public List<String> getFq() {
        return this.fq;
    }

    public void setFq(List<String> fq) {
        this.fq = fq;
    }

    public SolrFeature(String name, Map<String, Object> params) {
        super(name, params);
    }

    @Override
    public LinkedHashMap<String, Object> paramsToMap() {
        LinkedHashMap<String, Object> params = this.defaultParamsToMap();
        if (this.df != null) {
            params.put("df", this.df);
        }
        if (this.q != null) {
            params.put("q", this.q);
        }
        if (this.fq != null) {
            params.put("fq", this.fq);
        }
        return params;
    }

    @Override
    public Feature.FeatureWeight createWeight(IndexSearcher searcher, boolean needsScores, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) throws IOException {
        return new SolrFeatureWeight((SolrIndexSearcher)searcher, request, originalQuery, efi);
    }

    @Override
    protected void validate() throws FeatureException {
        if ((this.q == null || this.q.isEmpty()) && (this.fq == null || this.fq.isEmpty())) {
            throw new FeatureException(((Object)((Object)this)).getClass().getSimpleName() + ": Q or FQ must be provided");
        }
    }

    public class SolrFeatureWeight
    extends Feature.FeatureWeight {
        private final Weight solrQueryWeight;

        public SolrFeatureWeight(SolrIndexSearcher searcher, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) throws IOException {
            super(SolrFeature.this, (IndexSearcher)searcher, request, originalQuery, efi);
            try {
                Query scoreQuery;
                LocalSolrQueryRequest req = this.makeRequest(request.getCore(), SolrFeature.this.q, SolrFeature.this.fq, SolrFeature.this.df);
                if (req == null) {
                    throw new IOException("ERROR: No parameters provided");
                }
                String qStr = SolrFeature.this.q;
                if (qStr == null || qStr.isEmpty()) {
                    scoreQuery = null;
                } else {
                    if ((qStr = this.macroExpander.expand(qStr)) == null) {
                        throw new FeatureException(((Object)((Object)this)).getClass().getSimpleName() + " requires efi parameter that was not passed in request.");
                    }
                    scoreQuery = QParser.getParser((String)qStr, (SolrQueryRequest)req).getQuery();
                    if (scoreQuery == null) {
                        scoreQuery = new MatchNoDocsQuery();
                    }
                }
                Query filterDocSetQuery = null;
                if (SolrFeature.this.fq != null) {
                    ArrayList<Query> filterQueries = new ArrayList<Query>();
                    for (String fqStr : SolrFeature.this.fq) {
                        if (fqStr == null) continue;
                        if ((fqStr = this.macroExpander.expand(fqStr)) == null) {
                            throw new FeatureException(((Object)((Object)this)).getClass().getSimpleName() + " requires efi parameter that was not passed in request.");
                        }
                        Query filterQuery = QParser.getParser((String)fqStr, (SolrQueryRequest)req).getQuery();
                        if (filterQuery == null) continue;
                        filterQueries.add(filterQuery);
                    }
                    DocSet filtersDocSet = searcher.getDocSet(filterQueries);
                    if (filtersDocSet != searcher.getLiveDocSet()) {
                        filterDocSetQuery = filtersDocSet.makeQuery();
                    }
                }
                Query query = QueryUtils.combineQueryAndFilter(scoreQuery, filterDocSetQuery);
                this.solrQueryWeight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE, 1.0f);
            }
            catch (SyntaxError e) {
                throw new FeatureException("Failed to parse feature query.", (Exception)((Object)e));
            }
        }

        private LocalSolrQueryRequest makeRequest(SolrCore core, String solrQuery, List<String> fqs, String df) {
            NamedList returnList = new NamedList();
            if (solrQuery != null && !solrQuery.isEmpty()) {
                returnList.add("q", (Object)solrQuery);
            }
            if (fqs != null) {
                for (String fq : fqs) {
                    returnList.add("fq", (Object)fq);
                }
            }
            if (df != null && !df.isEmpty()) {
                returnList.add("df", (Object)df);
            }
            if (returnList.size() > 0) {
                return new LocalSolrQueryRequest(core, returnList);
            }
            return null;
        }

        @Override
        public Feature.FeatureWeight.FeatureScorer scorer(LeafReaderContext context) throws IOException {
            Scorer solrScorer = this.solrQueryWeight.scorer(context);
            if (solrScorer == null) {
                return null;
            }
            return new SolrFeatureScorer((Feature.FeatureWeight)this, solrScorer);
        }

        public class SolrFeatureScorer
        extends Feature.FeatureWeight.FilterFeatureScorer {
            public SolrFeatureScorer(Feature.FeatureWeight weight, Scorer solrScorer) {
                super(weight, solrScorer);
            }

            @Override
            public float score() throws IOException {
                try {
                    return this.in.score();
                }
                catch (UnsupportedOperationException e) {
                    throw new FeatureException(e.toString() + ": Unable to extract feature for " + this.name, e);
                }
            }
        }
    }
}

