/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.function.IntFunction;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;

public abstract class DocValuesAcc
extends SlotAcc {
    SchemaField sf;

    public DocValuesAcc(FacetContext fcontext, SchemaField sf) throws IOException {
        super(fcontext);
        this.sf = sf;
    }

    @Override
    public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
        if (this.advanceExact(doc)) {
            this.collectValues(doc, slot);
        }
    }

    protected abstract void collectValues(int var1, int var2) throws IOException;

    protected abstract boolean advanceExact(int var1) throws IOException;

    static abstract class SDVSortedSetAcc
    extends DoubleSortedSetDVAcc {
        int[] counts;
        double[] sum;

        public SDVSortedSetAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0.0);
            this.counts = new int[numSlots];
            this.sum = new double[numSlots];
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            long ord;
            while ((ord = this.values.nextOrd()) != -1L) {
                BytesRef term = this.values.lookupOrd(ord);
                Object obj = this.sf.getType().toObject(this.sf, term);
                double val = obj instanceof Date ? (double)((Date)obj).getTime() : ((Number)obj).doubleValue();
                int n = slot;
                this.result[n] = this.result[n] + val * val;
                int n2 = slot;
                this.sum[n2] = this.sum[n2] + val;
                int n3 = slot;
                this.counts[n3] = this.counts[n3] + 1;
            }
        }

        protected abstract double computeVal(int var1);

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.computeVal(slotA), this.computeVal(slotB));
        }

        @Override
        public Object getValue(int slot) {
            if (this.fcontext.isShard()) {
                ArrayList<Number> lst = new ArrayList<Number>(3);
                lst.add(this.counts[slot]);
                lst.add(this.result[slot]);
                lst.add(this.sum[slot]);
                return lst;
            }
            return this.computeVal(slot);
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            Arrays.fill(this.counts, 0);
            Arrays.fill(this.sum, 0.0);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            super.resize(resizer);
            this.counts = resizer.resize(this.counts, 0);
            this.sum = resizer.resize(this.sum, 0.0);
        }
    }

    static abstract class DoubleSortedSetDVAcc
    extends SortedSetDVAcc {
        double[] result;
        double initialValue;

        public DoubleSortedSetDVAcc(FacetContext fcontext, SchemaField sf, int numSlots, double initialValue) throws IOException {
            super(fcontext, sf, numSlots);
            this.result = new double[numSlots];
            this.initialValue = initialValue;
            if (initialValue != 0.0) {
                Arrays.fill(this.result, initialValue);
            }
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.result[slotA], this.result[slotB]);
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            return this.result[slotNum];
        }

        @Override
        public void reset() throws IOException {
            Arrays.fill(this.result, this.initialValue);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.result = resizer.resize(this.result, this.initialValue);
        }
    }

    static abstract class LongSortedSetDVAcc
    extends SortedSetDVAcc {
        long[] result;
        long initialValue;

        public LongSortedSetDVAcc(FacetContext fcontext, SchemaField sf, int numSlots, long initialValue) throws IOException {
            super(fcontext, sf, numSlots);
            this.result = new long[numSlots];
            this.initialValue = initialValue;
            if (initialValue != 0L) {
                Arrays.fill(this.result, initialValue);
            }
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Long.compare(this.result[slotA], this.result[slotB]);
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            return this.result[slotNum];
        }

        @Override
        public void reset() throws IOException {
            Arrays.fill(this.result, this.initialValue);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.result = resizer.resize(this.result, this.initialValue);
        }
    }

    static abstract class SortedSetDVAcc
    extends DocValuesAcc {
        SortedSetDocValues values;

        public SortedSetDVAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf);
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            super.setNextReader(readerContext);
            this.values = DocValues.getSortedSet((LeafReader)readerContext.reader(), (String)this.sf.getName());
        }

        @Override
        protected boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }
    }

    static abstract class SortedDVAcc
    extends DocValuesAcc {
        SortedDocValues values;

        public SortedDVAcc(FacetContext fcontext, SchemaField sf) throws IOException {
            super(fcontext, sf);
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            super.setNextReader(readerContext);
            this.values = DocValues.getSorted((LeafReader)readerContext.reader(), (String)this.sf.getName());
        }

        @Override
        protected boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }
    }

    static abstract class SDVSortedNumericAcc
    extends DoubleSortedNumericDVAcc {
        int[] counts;
        double[] sum;

        public SDVSortedNumericAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0.0);
            this.counts = new int[numSlots];
            this.sum = new double[numSlots];
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            int count = this.values.docValueCount();
            for (int i = 0; i < count; ++i) {
                double val = this.getDouble(this.values.nextValue());
                int n = slot;
                this.result[n] = this.result[n] + val * val;
                int n2 = slot;
                this.sum[n2] = this.sum[n2] + val;
                int n3 = slot;
                this.counts[n3] = this.counts[n3] + 1;
            }
        }

        protected abstract double computeVal(int var1);

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.computeVal(slotA), this.computeVal(slotB));
        }

        @Override
        public Object getValue(int slot) {
            if (this.fcontext.isShard()) {
                ArrayList<Number> lst = new ArrayList<Number>(3);
                lst.add(this.counts[slot]);
                lst.add(this.result[slot]);
                lst.add(this.sum[slot]);
                return lst;
            }
            return this.computeVal(slot);
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            Arrays.fill(this.counts, 0);
            Arrays.fill(this.sum, 0.0);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            super.resize(resizer);
            this.counts = resizer.resize(this.counts, 0);
            this.sum = resizer.resize(this.sum, 0.0);
        }
    }

    static abstract class DoubleSortedNumericDVAcc
    extends SortedNumericDVAcc {
        double[] result;
        double initialValue;

        public DoubleSortedNumericDVAcc(FacetContext fcontext, SchemaField sf, int numSlots, double initialValue) throws IOException {
            super(fcontext, sf, numSlots);
            this.result = new double[numSlots];
            this.initialValue = initialValue;
            if (initialValue != 0.0) {
                Arrays.fill(this.result, initialValue);
            }
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.result[slotA], this.result[slotB]);
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            return this.result[slotNum];
        }

        @Override
        public void reset() throws IOException {
            Arrays.fill(this.result, this.initialValue);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.result = resizer.resize(this.result, this.initialValue);
        }

        protected double getDouble(long val) {
            switch (this.sf.getType().getNumberType()) {
                case INTEGER: 
                case LONG: 
                case DATE: {
                    return val;
                }
                case FLOAT: {
                    return NumericUtils.sortableIntToFloat((int)((int)val));
                }
                case DOUBLE: {
                    return NumericUtils.sortableLongToDouble((long)val);
                }
            }
            return 0.0;
        }
    }

    static abstract class LongSortedNumericDVAcc
    extends SortedNumericDVAcc {
        long[] result;
        long initialValue;

        public LongSortedNumericDVAcc(FacetContext fcontext, SchemaField sf, int numSlots, long initialValue) throws IOException {
            super(fcontext, sf, numSlots);
            this.result = new long[numSlots];
            this.initialValue = initialValue;
            if (initialValue != 0L) {
                Arrays.fill(this.result, initialValue);
            }
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Long.compare(this.result[slotA], this.result[slotB]);
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            return this.result[slotNum];
        }

        @Override
        public void reset() throws IOException {
            Arrays.fill(this.result, this.initialValue);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.result = resizer.resize(this.result, this.initialValue);
        }
    }

    static abstract class SortedNumericDVAcc
    extends DocValuesAcc {
        SortedNumericDocValues values;

        public SortedNumericDVAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf);
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            super.setNextReader(readerContext);
            this.values = DocValues.getSortedNumeric((LeafReader)readerContext.reader(), (String)this.sf.getName());
        }

        @Override
        protected boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }
    }

    static abstract class NumericDVAcc
    extends DocValuesAcc {
        NumericDocValues values;

        public NumericDVAcc(FacetContext fcontext, SchemaField sf) throws IOException {
            super(fcontext, sf);
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            super.setNextReader(readerContext);
            this.values = DocValues.getNumeric((LeafReader)readerContext.reader(), (String)this.sf.getName());
        }

        @Override
        protected boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }
    }
}

