/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.entries;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PercentExpression {
    private static final String ZERO_CHARS = "00000000000000000000000000000000000000000000000000000000000000000000000";
    private static final String SPACE_CHARS = "                                                                      ";
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%([0#+ -]*)([0-9]*)(\\.([0-9]+))?([lqh]*)([%bcdeEfFgGiosuxX])");
    private final String expression;
    private final boolean justValue;
    private final boolean alternativeForm;
    private final boolean zeroPrefix;
    private final boolean plusPrefix;
    private final boolean spacePrefix;
    private final boolean leftAdjust;
    private final int totalWidth;
    private final int truncateWidth;
    private final char patternChar;
    private final Format decimalFormat;
    private final Format altDecimalFormat;

    PercentExpression(String expression) {
        this.expression = expression;
        Matcher matcher = FORMAT_PATTERN.matcher(expression);
        if (!matcher.matches() || matcher.group(6) == null || matcher.group(6).length() != 1) {
            this.justValue = true;
            this.alternativeForm = false;
            this.patternChar = '\u0000';
            this.zeroPrefix = false;
            this.plusPrefix = false;
            this.spacePrefix = false;
            this.leftAdjust = false;
            this.totalWidth = -1;
            this.truncateWidth = -1;
            this.decimalFormat = null;
            this.altDecimalFormat = null;
            return;
        }
        this.justValue = false;
        String flags = matcher.group(1);
        this.alternativeForm = PercentExpression.readFlag(flags, '#');
        this.zeroPrefix = PercentExpression.readFlag(flags, '0');
        this.plusPrefix = PercentExpression.readFlag(flags, '+');
        this.spacePrefix = this.plusPrefix ? false : PercentExpression.readFlag(flags, ' ');
        this.leftAdjust = PercentExpression.readFlag(flags, '-');
        this.totalWidth = PercentExpression.readPrecision(matcher.group(2), -1);
        int dotPrecision = PercentExpression.readPrecision(matcher.group(4), -1);
        this.patternChar = matcher.group(6).charAt(0);
        switch (this.patternChar) {
            case 'E': 
            case 'e': {
                this.decimalFormat = this.scientificFormat(dotPrecision);
                this.altDecimalFormat = null;
                break;
            }
            case 'F': 
            case 'f': {
                this.decimalFormat = this.decimalFormat(dotPrecision);
                this.altDecimalFormat = null;
                break;
            }
            case 'G': 
            case 'g': {
                this.decimalFormat = this.decimalFormat(dotPrecision);
                this.altDecimalFormat = this.scientificFormat(dotPrecision);
                break;
            }
            default: {
                this.decimalFormat = null;
                this.altDecimalFormat = null;
            }
        }
        this.truncateWidth = this.patternChar == 's' || this.patternChar == 'b' ? dotPrecision : -1;
    }

    public void append(Object extractedValue, StringBuilder sb) {
        if (this.justValue) {
            sb.append(extractedValue);
            return;
        }
        switch (this.patternChar) {
            case 'b': 
            case 's': {
                String strValue = extractedValue.toString();
                if (this.truncateWidth >= 0 && strValue.length() > this.truncateWidth) {
                    strValue = strValue.substring(0, this.truncateWidth);
                }
                this.appendValue(sb, null, null, strValue, false);
                return;
            }
            case 'c': {
                String str;
                String strValue = extractedValue instanceof Character ? Character.toString(((Character)extractedValue).charValue()) : (extractedValue instanceof Number ? Character.toString((char)((Number)extractedValue).shortValue()) : (extractedValue instanceof String ? ((str = (String)extractedValue).length() == 0 ? "" : str.substring(0, 1)) : "?"));
                this.appendValue(sb, null, null, strValue, false);
                return;
            }
            case 'd': 
            case 'i': 
            case 'u': {
                if (!(extractedValue instanceof Number)) break;
                long value = ((Number)extractedValue).longValue();
                String sign = null;
                if (value >= 0L) {
                    if (this.plusPrefix) {
                        sign = "+";
                    } else if (this.spacePrefix) {
                        sign = " ";
                    }
                } else {
                    sign = "-";
                    value = -value;
                }
                String strValue = Long.toString(value);
                this.appendValue(sb, sign, null, strValue, true);
                return;
            }
            case 'E': 
            case 'F': 
            case 'G': 
            case 'e': 
            case 'f': 
            case 'g': {
                String strValue2;
                if (!(extractedValue instanceof Number)) break;
                double value = ((Number)extractedValue).doubleValue();
                if (Double.isInfinite(value)) {
                    sb.append("inf");
                    return;
                }
                if (Double.isNaN(value)) {
                    sb.append("nan");
                    return;
                }
                String sign = null;
                if (value >= 0.0) {
                    if (this.plusPrefix) {
                        sign = "+";
                    } else if (this.spacePrefix) {
                        sign = " ";
                    }
                } else {
                    sign = "-";
                    value = -value;
                }
                String strValue = this.decimalFormat.format(value);
                if (this.altDecimalFormat != null && (strValue2 = this.altDecimalFormat.format(value)).length() < strValue.length()) {
                    strValue = strValue2;
                }
                this.appendValue(sb, sign, null, strValue, true);
                return;
            }
            case 'o': {
                if (!(extractedValue instanceof Number)) break;
                long value = ((Number)extractedValue).longValue();
                String sign = null;
                if (value < 0L) {
                    sign = "-";
                    value = -value;
                }
                String prefix = null;
                if (this.alternativeForm) {
                    prefix = "0";
                }
                String strValue = Long.toOctalString(value);
                this.appendValue(sb, sign, prefix, strValue, true);
                return;
            }
            case 'x': {
                if (!(extractedValue instanceof Number)) break;
                this.appendHex(sb, false, extractedValue);
                return;
            }
            case 'X': {
                if (!(extractedValue instanceof Number)) break;
                this.appendHex(sb, true, extractedValue);
                return;
            }
        }
        sb.append(extractedValue);
    }

    public String toString() {
        return this.expression;
    }

    private static int readPrecision(String string, int defaultVal) {
        if (string == null || string.length() == 0) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
    }

    private static boolean readFlag(String flags, char flagChar) {
        return flags != null && flags.indexOf(flagChar) >= 0;
    }

    private void appendHex(StringBuilder sb, boolean upper, Object extractedValue) {
        long value = ((Number)extractedValue).longValue();
        String sign = null;
        if (value < 0L) {
            sign = "-";
            value = -value;
        }
        String prefix = null;
        if (this.alternativeForm) {
            prefix = upper ? "0X" : "0x";
        }
        String strValue = Long.toHexString(value);
        if (upper) {
            strValue = strValue.toUpperCase();
        }
        this.appendValue(sb, sign, prefix, strValue, true);
    }

    private void appendValue(StringBuilder sb, String sign, String prefix, String value, boolean isNumber) {
        int diff;
        int len = 0;
        if (sign != null) {
            len += sign.length();
        }
        if (prefix != null) {
            len += prefix.length();
        }
        if ((diff = this.totalWidth - (len += value.length())) < 0) {
            diff = 0;
        }
        if (!this.leftAdjust) {
            if (isNumber && this.zeroPrefix) {
                if (sign != null) {
                    sb.append(sign);
                    sign = null;
                }
                if (prefix != null) {
                    sb.append(prefix);
                    prefix = null;
                }
                this.appendChars(sb, ZERO_CHARS, diff);
            } else {
                this.appendChars(sb, SPACE_CHARS, diff);
            }
        }
        if (sign != null) {
            sb.append(sign);
        }
        if (prefix != null) {
            sb.append(prefix);
        }
        sb.append(value);
        if (this.leftAdjust) {
            this.appendChars(sb, SPACE_CHARS, diff);
        }
    }

    private void appendChars(StringBuilder sb, String indentChars, int diff) {
        while (diff > indentChars.length()) {
            sb.append(indentChars);
            diff -= indentChars.length();
        }
        sb.append(indentChars, 0, diff);
    }

    private Format decimalFormat(int fractionPrecision) {
        DecimalFormat format;
        if (fractionPrecision == 0) {
            format = new DecimalFormat("###0");
        } else if (fractionPrecision > 0) {
            StringBuilder formatSb = new StringBuilder();
            formatSb.append("###0.");
            this.appendChars(formatSb, ZERO_CHARS, fractionPrecision);
            format = new DecimalFormat(formatSb.toString());
        } else {
            format = new DecimalFormat("###0.###");
        }
        return format;
    }

    private Format scientificFormat(int fractionPrecision) {
        DecimalFormat format;
        if (fractionPrecision == 0) {
            format = new DecimalFormat("0E0");
        } else if (fractionPrecision > 0) {
            StringBuilder formatSb = new StringBuilder();
            formatSb.append("0.");
            this.appendChars(formatSb, ZERO_CHARS, fractionPrecision);
            formatSb.append("E0");
            format = new DecimalFormat(formatSb.toString());
        } else {
            format = new DecimalFormat("0.###E0");
        }
        return format;
    }
}

