/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

public class MutableInteger {
    private int value;
    private Integer cachedIntegerValue = null;

    public MutableInteger(int i) {
        this.value = i;
    }

    public int intValue() {
        return this.value;
    }

    public Integer integerValue() {
        if (this.cachedIntegerValue == null) {
            this.cachedIntegerValue = this.intValue();
        }
        return this.cachedIntegerValue;
    }

    public boolean equals(Object o) {
        return o instanceof MutableInteger && ((MutableInteger)o).value == this.value;
    }

    public int hashCode() {
        return this.integerValue().hashCode();
    }

    public void setValue(int value) {
        this.value = value;
        this.cachedIntegerValue = null;
    }

    public void increment() {
        this.add(1);
    }

    public void add(int amount) {
        this.setValue(this.value + amount);
    }

    public void decrement() {
        this.subtract(1);
    }

    public void subtract(int amount) {
        this.add(amount * -1);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

