/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.fileinits;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileInitializer;
import org.eclipse.jetty.start.StartLog;

public class BaseHomeFileInitializer
extends FileInitializer {
    public BaseHomeFileInitializer(BaseHome basehome) {
        super(basehome, "basehome");
    }

    @Override
    public boolean create(URI uri, String location) throws IOException {
        if (uri.getSchemeSpecificPart().startsWith("/")) {
            throw new IllegalArgumentException(String.format("Bad file arg: %s", uri));
        }
        Path source = this._basehome.getPath(uri.getSchemeSpecificPart());
        if (!FS.exists(source)) {
            throw new IllegalArgumentException(String.format("File does not exist: %s", uri));
        }
        Path destination = location == null ? this._basehome.getBasePath() : this.getDestination(uri, location);
        boolean modified = false;
        if (Files.isDirectory(source, new LinkOption[0])) {
            if (destination != null && Files.exists(destination, new LinkOption[0])) {
                if (!Files.isDirectory(destination, new LinkOption[0])) {
                    StartLog.error("Cannot copy directory %s to file %s", source, destination);
                    return false;
                }
            } else if (FS.ensureDirectoryExists(destination)) {
                modified = true;
                StartLog.info("mkdir " + this._basehome.toShortForm(destination), new Object[0]);
            }
            this.copyDirectory(source, destination);
        } else {
            if (FS.ensureDirectoryExists(destination.getParent())) {
                modified = true;
                StartLog.info("mkdir " + this._basehome.toShortForm(destination.getParent()), new Object[0]);
            }
            if (!FS.exists(destination)) {
                StartLog.info("copy %s to %s", this._basehome.toShortForm(source), this._basehome.toShortForm(destination));
                Files.copy(source, destination, new CopyOption[0]);
                modified = true;
            }
        }
        return modified;
    }
}

