/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.spells;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.cleric.Trinity;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.spells.ClericSpell;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.HolyTome;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;

public class BodyForm
extends ClericSpell {
    public static BodyForm INSTANCE = new BodyForm();

    @Override
    public int icon() {
        return 61;
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", BodyForm.duration()) + "\n\n" + Messages.get(this, "charge_cost", (int)this.chargeUse(Dungeon.hero));
    }

    @Override
    public float chargeUse(Hero hero) {
        return 2.0f;
    }

    @Override
    public boolean canCast(Hero hero) {
        return super.canCast(hero) && hero.hasTalent(Talent.BODY_FORM);
    }

    @Override
    public void onCast(HolyTome tome, Hero hero) {
        GameScene.show(new Trinity.WndItemtypeSelect(tome, this));
    }

    public static int duration() {
        return Math.round(13.33f + 6.67f * (float)Dungeon.hero.pointsInTalent(Talent.BODY_FORM));
    }

    public static class BodyFormBuff
    extends FlavourBuff {
        private Bundlable effect;
        private static final String EFFECT = "effect";

        public BodyFormBuff() {
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 82;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(1.0f, 0.0f, 0.0f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, ((float)BodyForm.duration() - this.visualcooldown()) / (float)BodyForm.duration());
        }

        public void setEffect(Bundlable effect) {
            this.effect = effect;
        }

        public Weapon.Enchantment enchant() {
            if (this.effect instanceof Weapon.Enchantment) {
                return (Weapon.Enchantment)this.effect;
            }
            return null;
        }

        public Armor.Glyph glyph() {
            if (this.effect instanceof Armor.Glyph) {
                return (Armor.Glyph)this.effect;
            }
            return null;
        }

        @Override
        public String desc() {
            if (this.enchant() != null) {
                return Messages.get(this, "desc", Messages.titleCase(this.enchant().name()), this.dispTurns());
            }
            if (this.glyph() != null) {
                return Messages.get(this, "desc", Messages.titleCase(this.glyph().name()), this.dispTurns());
            }
            return super.desc();
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(EFFECT, this.effect);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.effect = bundle.get(EFFECT);
        }
    }
}

