/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing;

import net.atmp.SpecialText;
import net.sourceforge.plantuml.activitydiagram3.ftile.CenteredText;
import net.sourceforge.plantuml.klimt.CopyForegroundColorToBackgroundColor;
import net.sourceforge.plantuml.klimt.UAntiAliasing;
import net.sourceforge.plantuml.klimt.UBackground;
import net.sourceforge.plantuml.klimt.UChange;
import net.sourceforge.plantuml.klimt.UClip;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicNo;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.MinMaxMutable;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import net.sourceforge.plantuml.klimt.shape.UComment;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UEmpty;
import net.sourceforge.plantuml.klimt.shape.UHidden;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPixel;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.utils.ObjectUtils;

public final class LimitFinder
extends UGraphicNo {
    private final MinMaxMutable minmax;
    private UClip clip;
    private static final double HACK_X_FOR_POLYGON = 10.0;

    @Override
    public UGraphic apply(UChange change) {
        UTranslate tmp = change instanceof UTranslate ? this.getTranslate().compose((UTranslate)change) : this.getTranslate();
        LimitFinder result = new LimitFinder(this.getStringBounder(), tmp, this.minmax);
        if (!ObjectUtils.instanceOfAny(change, UAntiAliasing.class, UBackground.class, UClip.class, HColor.class, UHidden.class, UStroke.class, UTranslate.class, CopyForegroundColorToBackgroundColor.class)) {
            throw new UnsupportedOperationException(change.getClass().toString());
        }
        result.clip = change instanceof UClip ? ((UClip)change).translate(result.getTranslate()) : this.clip;
        return result;
    }

    public static LimitFinder create(StringBounder stringBounder, boolean initToZero) {
        LimitFinder result = new LimitFinder(stringBounder, UTranslate.none(), MinMaxMutable.getEmpty(initToZero));
        result.clip = null;
        return result;
    }

    private LimitFinder(StringBounder stringBounder, UTranslate translate, MinMaxMutable minmax) {
        super(stringBounder, translate);
        this.minmax = minmax;
    }

    public void draw(UShape shape) {
        double x = this.getTranslate().getDx();
        double y = this.getTranslate().getDy();
        if (shape instanceof UText) {
            this.drawText(x, y, (UText)shape);
        } else if (shape instanceof ULine) {
            this.drawULine(x, y, (ULine)shape);
        } else if (shape instanceof UEllipse) {
            this.drawEllipse(x, y, (UEllipse)shape);
        } else if (shape instanceof UPolygon) {
            this.drawUPolygon(x, y, (UPolygon)shape);
        } else if (shape instanceof UPath) {
            this.drawUPath(x, y, (UPath)shape);
        } else if (shape instanceof URectangle) {
            this.drawRectangle(x, y, (URectangle)shape);
        } else if (shape instanceof DotPath) {
            this.drawDotPath(x, y, (DotPath)shape);
        } else if (shape instanceof UImage) {
            this.drawImage(x, y, (UImage)shape);
        } else if (shape instanceof UImageSvg) {
            this.drawImageSvg(x, y, (UImageSvg)shape);
        } else if (!(shape instanceof UComment)) {
            if (shape instanceof UEmpty) {
                this.drawEmpty(x, y, (UEmpty)shape);
            } else if (shape instanceof TextBlock) {
                TextBlock tb = (TextBlock)shape;
                tb.drawU(this);
            } else if (!(shape instanceof UCenteredCharacter || shape instanceof CenteredText || shape instanceof SpecialText || shape instanceof CopyForegroundColorToBackgroundColor)) {
                if (shape instanceof UPixel) {
                    this.addPoint(x, y);
                } else {
                    throw new UnsupportedOperationException(shape.getClass().getName());
                }
            }
        }
    }

    private void addPoint(double x, double y) {
        if (this.clip == null || this.clip.isInside(x, y)) {
            this.minmax.addPoint(x, y);
        }
    }

    private void drawEmpty(double x, double y, UEmpty shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth(), y + shape.getHeight());
    }

    private void drawUPath(double x, double y, UPath shape) {
        this.addPoint(x + shape.getMinX(), y + shape.getMinY());
        this.addPoint(x + shape.getMaxX(), y + shape.getMaxY());
    }

    private void drawUPolygon(double x, double y, UPolygon shape) {
        if (shape.getPoints().size() == 0) {
            return;
        }
        this.addPoint(x + shape.getMinX() - 10.0, y + shape.getMinY());
        this.addPoint(x + shape.getMaxX() + 10.0, y + shape.getMaxY());
    }

    private void drawULine(double x, double y, ULine shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getDX(), y + shape.getDY());
    }

    private void drawRectangle(double x, double y, URectangle shape) {
        this.addPoint(x - 1.0, y - 1.0);
        this.addPoint(x + shape.getWidth() - 1.0 + shape.getDeltaShadow() * 2.0, y + shape.getHeight() - 1.0 + shape.getDeltaShadow() * 2.0);
    }

    private void drawDotPath(double x, double y, DotPath shape) {
        MinMax shapeMinMax = shape.getMinMax();
        this.addPoint(x + shapeMinMax.getMinX(), y + shapeMinMax.getMinY());
        this.addPoint(x + shapeMinMax.getMaxX(), y + shapeMinMax.getMaxY());
    }

    private void drawImage(double x, double y, UImage shape) {
        this.addPoint(x, y);
        this.addPoint(x + (double)shape.getWidth() - 1.0, y + (double)shape.getHeight() - 1.0);
    }

    private void drawImageSvg(double x, double y, UImageSvg shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth() - 1.0, y + shape.getHeight() - 1.0);
    }

    private void drawEllipse(double x, double y, UEllipse shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth() - 1.0 + shape.getDeltaShadow() * 2.0, y + shape.getHeight() - 1.0 + shape.getDeltaShadow() * 2.0);
    }

    private void drawText(double x, double y, UText text) {
        XDimension2D dim = this.getStringBounder().calculateDimension(text.getFontConfiguration().getFont(), text.getText());
        this.addPoint(x, y -= dim.getHeight() - 1.5);
        this.addPoint(x, y + dim.getHeight());
        this.addPoint(x + dim.getWidth(), y);
        this.addPoint(x + dim.getWidth(), y + dim.getHeight());
    }

    @Override
    public ColorMapper getColorMapper() {
        return ColorMapper.IDENTITY;
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    public MinMax getMinMax() {
        if (this.minmax.isInfinity()) {
            return MinMax.getEmpty(true);
        }
        return MinMax.fromMutable(this.minmax);
    }
}

