/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.emoji;

import java.awt.geom.AffineTransform;
import net.sourceforge.plantuml.emoji.ColorResolver;
import net.sourceforge.plantuml.klimt.UChange;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;

public class UGraphicWithScale {
    private final UGraphic ug;
    private final AffineTransform at;
    private final double angle;
    private final double scale;
    private final ColorResolver colorResolver;

    public UGraphicWithScale(UGraphic ug, ColorResolver colorResolver, double scale) {
        this(UGraphicWithScale.updateColor(ug, colorResolver), colorResolver, AffineTransform.getScaleInstance(scale, scale), 0.0, scale);
    }

    private static UGraphic updateColor(UGraphic ug, ColorResolver colorResolver) {
        HColor color = colorResolver.getDefaultColor();
        return ug.apply(color).apply(color.bg());
    }

    private UGraphicWithScale(UGraphic ug, ColorResolver colorResolver, AffineTransform at, double angle, double scale) {
        this.ug = ug;
        this.colorResolver = colorResolver;
        this.at = at;
        this.angle = angle;
        this.scale = scale;
    }

    public UGraphic getUg() {
        return this.ug;
    }

    public UGraphicWithScale apply(UChange change) {
        return new UGraphicWithScale(this.ug.apply(change), this.colorResolver, this.at, this.angle, this.scale);
    }

    public HColor getTrueColor(String code) {
        return this.colorResolver.getTrueColor(code);
    }

    public HColor getDefaultColor() {
        return this.colorResolver.getDefaultColor();
    }

    public UGraphicWithScale applyScale(double changex, double changey) {
        if (changex != changey) {
            throw new IllegalArgumentException();
        }
        AffineTransform copy = new AffineTransform(this.at);
        copy.scale(changex, changey);
        return new UGraphicWithScale(this.ug, this.colorResolver, copy, this.angle, 1.0 * changex);
    }

    public void draw(UShape shape) {
        this.ug.draw(shape);
    }

    public UGraphicWithScale applyRotate(double delta_angle, double x, double y) {
        AffineTransform copy = new AffineTransform(this.at);
        copy.rotate(delta_angle * Math.PI / 180.0, x, y);
        return new UGraphicWithScale(this.ug, this.colorResolver, copy, this.angle + delta_angle, this.scale);
    }

    public UGraphicWithScale applyTranslate(double x, double y) {
        AffineTransform copy = new AffineTransform(this.at);
        copy.translate(x, y);
        return new UGraphicWithScale(this.ug, this.colorResolver, copy, this.angle, this.scale);
    }

    public AffineTransform getAffineTransform() {
        return this.at;
    }

    public UGraphicWithScale applyMatrix(double v1, double v2, double v3, double v4, double v5, double v6) {
        AffineTransform copy = new AffineTransform(this.at);
        copy.concatenate(new AffineTransform(new double[]{v1, v2, v3, v4, v5, v6}));
        return new UGraphicWithScale(this.ug, this.colorResolver, copy, this.angle, this.scale);
    }

    public final double getAngle() {
        return this.angle;
    }

    public double getScale() {
        return this.scale;
    }
}

