/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import mediathek.gui.tabs.tab_film.GuiFilme;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.FileDialogs;
import mediathek.tool.MVSubtitle;
import mediathek.tool.SwingErrorDialog;

public class DownloadSubtitleAction
extends AbstractAction {
    private final GuiFilme guiFilme;

    public DownloadSubtitleAction(GuiFilme guiFilme) {
        this.guiFilme = guiFilme;
        this.putValue("Name", "Untertitel-Datei sofort laden...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.guiFilme.getCurrentlySelectedFilm().ifPresent(film -> {
            File selectedFile = FileDialogs.chooseSaveFileLocation(MediathekGui.ui(), "Untertitel speichern", "");
            if (selectedFile != null) {
                try {
                    MVSubtitle subtitleFile = new MVSubtitle();
                    subtitleFile.writeSubtitle(film.getSubtitleUrl(), selectedFile);
                    JOptionPane.showMessageDialog(MediathekGui.ui(), "Untertitel wurde erfolgreich geladen.", "MediathekView", 1);
                }
                catch (Exception ex) {
                    SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "Untertitel konnte nicht geladen werden.", ex);
                }
            } else {
                JOptionPane.showMessageDialog(MediathekGui.ui(), "Vorgang wurde abgebrochen.", "MediathekView", 2);
            }
        });
    }
}

