/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProviderFactory;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.condition.IdentityProviderCondition;

public class IdentityProviderConditionFactory
extends AbstractClientPolicyConditionProviderFactory {
    public static final String PROVIDER_ID = "identity-provider-alias";
    public static final String IDENTITY_PROVIDERS_ALIASES = "identity_provider_aliases";

    public ClientPolicyConditionProvider create(KeycloakSession session) {
        return new IdentityProviderCondition(session);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "Condition that checks the Identity Provider that is involved in the client request.\nOnly applies to operations in which an IdP is involved (for example JWT Authorization grant).\n";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        List properties = ProviderConfigurationBuilder.create().property().name(IDENTITY_PROVIDERS_ALIASES).type("IdentityProviderMultiList").label("Identity provider aliases").helpText("List of Identity Provider aliases to take into consideration for the condition.").required(Boolean.TRUE.booleanValue()).add().build();
        IdentityProviderConditionFactory.addCommonConfigProperties((List)properties);
        return properties;
    }
}

