/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class JandexReflection {
    public static java.lang.reflect.Type loadType(Type type) {
        TypeVariables typeVariables = new TypeVariables();
        java.lang.reflect.Type result = JandexReflection.loadType(type, typeVariables);
        typeVariables.patchReferences();
        return result;
    }

    private static java.lang.reflect.Type loadType(Type type, TypeVariables typeVariables) {
        if (type == null) {
            return null;
        }
        switch (type.kind()) {
            case VOID: {
                return Void.TYPE;
            }
            case PRIMITIVE: {
                switch (type.asPrimitiveType().primitive()) {
                    case BOOLEAN: {
                        return Boolean.TYPE;
                    }
                    case BYTE: {
                        return Byte.TYPE;
                    }
                    case SHORT: {
                        return Short.TYPE;
                    }
                    case INT: {
                        return Integer.TYPE;
                    }
                    case LONG: {
                        return Long.TYPE;
                    }
                    case FLOAT: {
                        return Float.TYPE;
                    }
                    case DOUBLE: {
                        return Double.TYPE;
                    }
                    case CHAR: {
                        return Character.TYPE;
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type: " + type);
            }
            case CLASS: {
                return JandexReflection.load(type.name());
            }
            case PARAMETERIZED_TYPE: {
                java.lang.reflect.Type ownerType = null;
                if (type.asParameterizedType().owner() != null) {
                    ownerType = JandexReflection.loadType(type.asParameterizedType().owner(), typeVariables);
                }
                Class<?> rawType = JandexReflection.load(type.name());
                Type[] typeArguments = type.asParameterizedType().argumentsArray();
                java.lang.reflect.Type[] typeArgumentsReflective = new java.lang.reflect.Type[typeArguments.length];
                for (int i = 0; i < typeArguments.length; ++i) {
                    typeArgumentsReflective[i] = JandexReflection.loadType(typeArguments[i], typeVariables);
                }
                return new ParameterizedTypeImpl(rawType, typeArgumentsReflective, ownerType);
            }
            case ARRAY: {
                Type.Kind elementTypeKind = type.asArrayType().elementType().kind();
                if (elementTypeKind == Type.Kind.PRIMITIVE || elementTypeKind == Type.Kind.CLASS) {
                    return JandexReflection.load(type.name());
                }
                java.lang.reflect.Type componentType = JandexReflection.loadType(type.asArrayType().componentType(), typeVariables);
                return new GenericArrayTypeImpl(componentType);
            }
            case WILDCARD_TYPE: {
                if (type.asWildcardType().hasImplicitObjectBound()) {
                    return WildcardTypeImpl.unbounded();
                }
                java.lang.reflect.Type bound = JandexReflection.loadType(type.asWildcardType().bound(), typeVariables);
                if (type.asWildcardType().isExtends()) {
                    return WildcardTypeImpl.withUpperBound(bound);
                }
                return WildcardTypeImpl.withLowerBound(bound);
            }
            case TYPE_VARIABLE: {
                String tvIdentifier = type.asTypeVariable().identifier();
                TypeVariableImpl<Object> typeVariable = typeVariables.getTypeVariable(tvIdentifier);
                if (typeVariable == null) {
                    Type[] bounds = type.asTypeVariable().boundArray();
                    java.lang.reflect.Type[] boundsReflective = new java.lang.reflect.Type[bounds.length];
                    for (int i = 0; i < bounds.length; ++i) {
                        boundsReflective[i] = JandexReflection.loadType(bounds[i], typeVariables);
                    }
                    typeVariable = new TypeVariableImpl(tvIdentifier, boundsReflective);
                    typeVariables.setTypeVariable(tvIdentifier, typeVariable);
                }
                return typeVariable;
            }
            case TYPE_VARIABLE_REFERENCE: {
                String tvrIdentifier = type.asTypeVariableReference().identifier();
                TypeVariableReferenceImpl<Object> typeVariableReference = typeVariables.getTypeVariableReference(tvrIdentifier);
                if (typeVariableReference == null) {
                    typeVariableReference = new TypeVariableReferenceImpl();
                    typeVariables.setTypeVariableReference(tvrIdentifier, typeVariableReference);
                }
                return typeVariableReference;
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                String utvIdentifier = type.asUnresolvedTypeVariable().identifier();
                TypeVariableImpl<Object> unresolvedTypeVariable = typeVariables.getTypeVariable(utvIdentifier);
                if (unresolvedTypeVariable == null) {
                    unresolvedTypeVariable = new TypeVariableImpl(utvIdentifier, new java.lang.reflect.Type[0]);
                    typeVariables.setTypeVariable(utvIdentifier, unresolvedTypeVariable);
                }
                return unresolvedTypeVariable;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static Class<?> loadRawType(Type type) {
        if (type == null) {
            return null;
        }
        switch (type.kind()) {
            case VOID: {
                return Void.TYPE;
            }
            case PRIMITIVE: {
                switch (type.asPrimitiveType().primitive()) {
                    case BOOLEAN: {
                        return Boolean.TYPE;
                    }
                    case BYTE: {
                        return Byte.TYPE;
                    }
                    case SHORT: {
                        return Short.TYPE;
                    }
                    case INT: {
                        return Integer.TYPE;
                    }
                    case LONG: {
                        return Long.TYPE;
                    }
                    case FLOAT: {
                        return Float.TYPE;
                    }
                    case DOUBLE: {
                        return Double.TYPE;
                    }
                    case CHAR: {
                        return Character.TYPE;
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type: " + type);
            }
            case CLASS: 
            case PARAMETERIZED_TYPE: 
            case ARRAY: 
            case WILDCARD_TYPE: 
            case TYPE_VARIABLE: 
            case TYPE_VARIABLE_REFERENCE: {
                return JandexReflection.load(type.name());
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                return Object.class;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static Class<?> loadClass(ClassInfo clazz) {
        if (clazz == null) {
            return null;
        }
        return JandexReflection.load(clazz.name());
    }

    private static Class<?> load(DotName name) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = JandexReflection.class.getClassLoader();
            }
            return Class.forName(name.toString(), false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class TypeVariables {
        private Map<String, TypeVariableImpl<?>> typeVariables;
        private Map<String, TypeVariableReferenceImpl<?>> typeVariableReferences;

        private TypeVariables() {
        }

        TypeVariableImpl<?> getTypeVariable(String identifier) {
            return this.typeVariables != null ? this.typeVariables.get(identifier) : null;
        }

        void setTypeVariable(String identifier, TypeVariableImpl<?> typeVariable) {
            if (this.typeVariables == null) {
                this.typeVariables = new HashMap();
            }
            this.typeVariables.put(identifier, typeVariable);
        }

        TypeVariableReferenceImpl<?> getTypeVariableReference(String identifier) {
            return this.typeVariableReferences != null ? this.typeVariableReferences.get(identifier) : null;
        }

        void setTypeVariableReference(String identifier, TypeVariableReferenceImpl<?> typeVariableReference) {
            if (this.typeVariableReferences == null) {
                this.typeVariableReferences = new HashMap();
            }
            this.typeVariableReferences.put(identifier, typeVariableReference);
        }

        void patchReferences() {
            if (this.typeVariableReferences == null) {
                return;
            }
            this.typeVariableReferences.forEach((identifier, reference) -> {
                TypeVariableImpl<?> typeVar = this.typeVariables.get(identifier);
                if (typeVar != null) {
                    reference.setDelegate(typeVar);
                }
            });
        }
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final java.lang.reflect.Type ownerType;
        private final java.lang.reflect.Type rawType;
        private final java.lang.reflect.Type[] actualTypeArguments;

        ParameterizedTypeImpl(java.lang.reflect.Type rawType, java.lang.reflect.Type[] actualTypeArguments, java.lang.reflect.Type ownerType) {
            this.ownerType = ownerType;
            this.rawType = rawType;
            this.actualTypeArguments = actualTypeArguments;
        }

        @Override
        public java.lang.reflect.Type[] getActualTypeArguments() {
            return Arrays.copyOf(this.actualTypeArguments, this.actualTypeArguments.length);
        }

        @Override
        public java.lang.reflect.Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public java.lang.reflect.Type getRawType() {
            return this.rawType;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ParameterizedType) {
                ParameterizedType that = (ParameterizedType)obj;
                return Objects.equals(this.ownerType, that.getOwnerType()) && Objects.equals(this.rawType, that.getRawType()) && Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.actualTypeArguments) ^ Objects.hashCode(this.ownerType) ^ Objects.hashCode(this.rawType);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.rawType.getTypeName());
            StringJoiner joiner = new StringJoiner(", ", "<", ">");
            joiner.setEmptyValue("");
            for (java.lang.reflect.Type typeArgument : this.actualTypeArguments) {
                joiner.add(typeArgument.getTypeName());
            }
            result.append(joiner);
            return result.toString();
        }
    }

    private static class GenericArrayTypeImpl
    implements GenericArrayType {
        private final java.lang.reflect.Type genericComponentType;

        GenericArrayTypeImpl(java.lang.reflect.Type genericComponentType) {
            this.genericComponentType = genericComponentType;
        }

        @Override
        public java.lang.reflect.Type getGenericComponentType() {
            return this.genericComponentType;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof GenericArrayType) {
                GenericArrayType that = (GenericArrayType)obj;
                return Objects.equals(this.genericComponentType, that.getGenericComponentType());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.genericComponentType);
        }

        public String toString() {
            return this.genericComponentType + "[]";
        }
    }

    private static class WildcardTypeImpl
    implements WildcardType {
        private static final java.lang.reflect.Type[] DEFAULT_UPPER_BOUND = new java.lang.reflect.Type[]{Object.class};
        private static final java.lang.reflect.Type[] DEFAULT_LOWER_BOUND = new java.lang.reflect.Type[0];
        private static final WildcardType UNBOUNDED = new WildcardTypeImpl(DEFAULT_UPPER_BOUND, DEFAULT_LOWER_BOUND);
        private final java.lang.reflect.Type[] upperBound;
        private final java.lang.reflect.Type[] lowerBound;

        static WildcardType unbounded() {
            return UNBOUNDED;
        }

        static WildcardType withUpperBound(java.lang.reflect.Type type) {
            return new WildcardTypeImpl(new java.lang.reflect.Type[]{type}, DEFAULT_LOWER_BOUND);
        }

        static WildcardType withLowerBound(java.lang.reflect.Type type) {
            return new WildcardTypeImpl(DEFAULT_UPPER_BOUND, new java.lang.reflect.Type[]{type});
        }

        private WildcardTypeImpl(java.lang.reflect.Type[] upperBound, java.lang.reflect.Type[] lowerBound) {
            this.upperBound = upperBound;
            this.lowerBound = lowerBound;
        }

        @Override
        public java.lang.reflect.Type[] getUpperBounds() {
            return this.upperBound;
        }

        @Override
        public java.lang.reflect.Type[] getLowerBounds() {
            return this.lowerBound;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WildcardType) {
                WildcardType that = (WildcardType)obj;
                return Arrays.equals(this.lowerBound, that.getLowerBounds()) && Arrays.equals(this.upperBound, that.getUpperBounds());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.lowerBound) ^ Arrays.hashCode(this.upperBound);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("?");
            if (this.upperBound.length > 0 && !this.upperBound[0].equals(Object.class)) {
                result.append(" extends ").append(this.upperBound[0]);
            } else if (this.lowerBound.length > 0) {
                result.append(" super ").append(this.lowerBound[0]);
            }
            return result.toString();
        }
    }

    private static class TypeVariableImpl<D extends GenericDeclaration>
    implements TypeVariable<D> {
        private final String name;
        private final java.lang.reflect.Type[] bounds;

        TypeVariableImpl(String name, java.lang.reflect.Type ... bounds) {
            this.name = name;
            this.bounds = bounds;
        }

        @Override
        public java.lang.reflect.Type[] getBounds() {
            return Arrays.copyOf(this.bounds, this.bounds.length);
        }

        @Override
        public D getGenericDeclaration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public AnnotatedType[] getAnnotatedBounds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Annotation[] getAnnotations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TypeVariable) {
                TypeVariable that = (TypeVariable)obj;
                return Objects.equals(this.name, that.getName()) && Arrays.equals(this.bounds, that.getBounds());
            }
            return false;
        }

        public int hashCode() {
            int result = Objects.hashCode(this.name);
            result = 31 * result + Arrays.hashCode(this.bounds);
            return result;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(" & ", " extends ", "");
            joiner.setEmptyValue("");
            for (java.lang.reflect.Type bound : this.bounds) {
                if (bound instanceof Class) {
                    joiner.add(((Class)bound).getName());
                    continue;
                }
                joiner.add(bound.toString());
            }
            return this.name + joiner;
        }
    }

    private static class TypeVariableReferenceImpl<D extends GenericDeclaration>
    implements TypeVariable<D> {
        private TypeVariableImpl<D> delegate;

        private TypeVariableReferenceImpl() {
        }

        void setDelegate(TypeVariableImpl<D> delegate) {
            this.delegate = delegate;
        }

        @Override
        public java.lang.reflect.Type[] getBounds() {
            return this.delegate.getBounds();
        }

        @Override
        public D getGenericDeclaration() {
            return this.delegate.getGenericDeclaration();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public AnnotatedType[] getAnnotatedBounds() {
            return this.delegate.getAnnotatedBounds();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.delegate.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.delegate.getAnnotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.delegate.getDeclaredAnnotations();
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

