/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;

public interface ThreadContext {
    public static final String ALL_REMAINING = "Remaining";
    public static final String APPLICATION = "Application";
    public static final String CDI = "CDI";
    public static final String[] NONE = new String[0];
    public static final String SECURITY = "Security";
    public static final String TRANSACTION = "Transaction";

    public static Builder builder() {
        return ContextManagerProvider.instance().getContextManager().newThreadContextBuilder();
    }

    public Executor currentContextExecutor();

    public <R> Callable<R> contextualCallable(Callable<R> var1);

    public <T, U> BiConsumer<T, U> contextualConsumer(BiConsumer<T, U> var1);

    public <T> Consumer<T> contextualConsumer(Consumer<T> var1);

    public <T, U, R> BiFunction<T, U, R> contextualFunction(BiFunction<T, U, R> var1);

    public <T, R> Function<T, R> contextualFunction(Function<T, R> var1);

    public Runnable contextualRunnable(Runnable var1);

    public <R> Supplier<R> contextualSupplier(Supplier<R> var1);

    public <T> CompletableFuture<T> withContextCapture(CompletableFuture<T> var1);

    public <T> CompletionStage<T> withContextCapture(CompletionStage<T> var1);

    public static interface Builder {
        public ThreadContext build();

        public Builder cleared(String ... var1);

        public Builder propagated(String ... var1);

        public Builder unchanged(String ... var1);
    }
}

