/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan.remote;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.api.AsyncCache;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.concurrent.BlockingManager;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.NodeInfo;
import org.keycloak.connections.infinispan.TopologyInfo;

public record RemoteInfinispanConnectionProvider(EmbeddedCacheManager embeddedCacheManager, RemoteCacheManager remoteCacheManager, TopologyInfo topologyInfo, NodeInfo nodeInfo) implements InfinispanConnectionProvider
{
    public RemoteInfinispanConnectionProvider {
        Objects.requireNonNull(embeddedCacheManager);
        Objects.requireNonNull(remoteCacheManager);
        Objects.requireNonNull(topologyInfo);
        Objects.requireNonNull(nodeInfo);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String name, boolean createIfAbsent) {
        return this.embeddedCacheManager.getCache(name, createIfAbsent);
    }

    @Override
    public <K, V> RemoteCache<K, V> getRemoteCache(String name) {
        return this.remoteCacheManager.getCache(name);
    }

    @Override
    public TopologyInfo getTopologyInfo() {
        return this.topologyInfo;
    }

    @Override
    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    @Override
    public CompletionStage<Void> migrateToProtoStream() {
        AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
        InfinispanConnectionProvider.skipSessionsCacheIfRequired(Arrays.stream(CLUSTERED_CACHE_NAMES)).map(this::getRemoteCache).map(AsyncCache::clearAsync).forEach(arg_0 -> ((AggregateCompletionStage)stage).dependsOn(arg_0));
        return stage.freeze();
    }

    @Override
    public ScheduledExecutorService getScheduledExecutor() {
        return (ScheduledExecutorService)GlobalComponentRegistry.of((EmbeddedCacheManager)this.embeddedCacheManager).getComponent(ScheduledExecutorService.class, "org.infinispan.executors.timeout");
    }

    @Override
    public BlockingManager getBlockingManager() {
        return (BlockingManager)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)this.embeddedCacheManager, BlockingManager.class);
    }

    public void close() {
    }
}

