/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.broker.provider.mappersync.ConfigSyncEventListener;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderEventListener;

public abstract class AbstractIdentityProviderMapper
implements IdentityProviderMapper {
    private static final Logger LOG = Logger.getLogger(AbstractIdentityProviderMapper.class);
    private static volatile KeycloakSessionFactory keycloakSessionFactory;

    public void close() {
    }

    public IdentityProviderMapper create(KeycloakSession session) {
        return null;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.registerConfigSyncEventListenerOnce(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerConfigSyncEventListenerOnce(KeycloakSessionFactory factory) {
        if (keycloakSessionFactory == factory) return;
        Class<AbstractIdentityProviderMapper> clazz = AbstractIdentityProviderMapper.class;
        synchronized (AbstractIdentityProviderMapper.class) {
            if (keycloakSessionFactory == factory) return;
            keycloakSessionFactory = factory;
            LOG.debugf("Registering %s", ConfigSyncEventListener.class);
            factory.register((ProviderEventListener)new ConfigSyncEventListener());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
    }

    @Override
    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
    }

    @Override
    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
    }

    @Override
    public void updateBrokeredUserLegacy(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        this.updateBrokeredUser(session, realm, user, mapperModel, context);
    }
}

