/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.workflow.admin.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowSetRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;
import org.keycloak.workflow.admin.resource.WorkflowResource;

public class WorkflowsResource {
    private final KeycloakSession session;
    private final WorkflowsManager manager;
    private final AdminPermissionEvaluator auth;

    public WorkflowsResource(KeycloakSession session, AdminPermissionEvaluator auth) {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.WORKFLOWS)) {
            throw new NotFoundException();
        }
        this.session = session;
        this.manager = new WorkflowsManager(session);
        this.auth = auth;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response create(WorkflowRepresentation rep) {
        this.auth.realm().requireManageRealm();
        try {
            Workflow workflow = this.manager.toModel(rep);
            return Response.created((URI)this.session.getContext().getUri().getRequestUriBuilder().path(workflow.getId()).build(new Object[0])).build();
        }
        catch (ModelException me) {
            throw ErrorResponse.error(me.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="set")
    @POST
    @Consumes(value={"application/json"})
    public Response createAll(WorkflowSetRepresentation workflows) {
        this.auth.realm().requireManageRealm();
        for (WorkflowRepresentation workflow : Optional.ofNullable(workflows.getWorkflows()).orElse(List.of())) {
            this.create(workflow).close();
        }
        return Response.created((URI)this.session.getContext().getUri().getRequestUri()).build();
    }

    @Path(value="{id}")
    public WorkflowResource get(@PathParam(value="id") String id) {
        this.auth.realm().requireManageRealm();
        Workflow workflow = this.manager.getWorkflow(id);
        if (workflow == null) {
            throw new NotFoundException("Workflow with id " + id + " not found");
        }
        return new WorkflowResource(this.manager, workflow);
    }

    @GET
    @Produces(value={"application/json"})
    public List<WorkflowRepresentation> list() {
        this.auth.realm().requireManageRealm();
        return this.manager.getWorkflows().stream().map(this.manager::toRepresentation).toList();
    }
}

