/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.keycloak.protocol.oid4vc.model.PreAuthorizedGrant;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CredentialsOffer {
    @JsonProperty(value="credential_issuer")
    private String credentialIssuer;
    @JsonProperty(value="credential_configuration_ids")
    private List<String> credentialConfigurationIds;
    private PreAuthorizedGrant grants;

    public String getCredentialIssuer() {
        return this.credentialIssuer;
    }

    public CredentialsOffer setCredentialIssuer(String credentialIssuer) {
        this.credentialIssuer = credentialIssuer;
        return this;
    }

    public List<String> getCredentialConfigurationIds() {
        return this.credentialConfigurationIds;
    }

    public CredentialsOffer setCredentialConfigurationIds(List<String> credentialConfigurationIds) {
        this.credentialConfigurationIds = Collections.unmodifiableList(credentialConfigurationIds);
        return this;
    }

    public PreAuthorizedGrant getGrants() {
        return this.grants;
    }

    public CredentialsOffer setGrants(PreAuthorizedGrant grants) {
        this.grants = grants;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CredentialsOffer)) {
            return false;
        }
        CredentialsOffer that = (CredentialsOffer)o;
        return Objects.equals(this.getCredentialIssuer(), that.getCredentialIssuer()) && Objects.equals(this.getCredentialConfigurationIds(), that.getCredentialConfigurationIds()) && Objects.equals(this.getGrants(), that.getGrants());
    }

    public int hashCode() {
        return Objects.hash(this.getCredentialIssuer(), this.getCredentialConfigurationIds(), this.getGrants());
    }
}

