/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.arc.Lock;
import io.quarkus.arc.LockException;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Lock
@Interceptor
@Priority(value=0)
public class LockInterceptor {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final ReentrantLock rl = new ReentrantLock();

    @AroundInvoke
    Object lock(ArcInvocationContext ctx) throws Exception {
        Lock lock = this.getLock(ctx);
        switch (lock.value()) {
            case WRITE: {
                return this.writeLock(lock, ctx);
            }
            case READ: {
                return this.readLock(lock, ctx);
            }
            case NONE: {
                return ctx.proceed();
            }
        }
        throw new LockException("Unsupported @Lock type found on business method " + String.valueOf(ctx.getMethod()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object writeLock(Lock lock, InvocationContext ctx) throws Exception {
        long time = lock.time();
        int readHoldCount = this.rwl.getReadHoldCount();
        boolean locked = false;
        try {
            if (readHoldCount > 0) {
                this.rl.lock();
            }
            try {
                if (readHoldCount > 0) {
                    for (int i = 0; i < readHoldCount; ++i) {
                        this.rwl.readLock().unlock();
                    }
                }
                if (time > 0L) {
                    locked = this.rwl.writeLock().tryLock(time, lock.unit());
                    if (!locked) {
                        throw new LockException("Write lock not acquired in " + lock.unit().toMillis(time) + " ms");
                    }
                } else {
                    this.rwl.writeLock().lock();
                    locked = true;
                }
            }
            finally {
                if (readHoldCount > 0) {
                    this.rl.unlock();
                }
            }
            Object object = ctx.proceed();
            return object;
        }
        finally {
            if (locked) {
                if (readHoldCount > 0) {
                    for (int i = 0; i < readHoldCount; ++i) {
                        this.rwl.readLock().lock();
                    }
                }
                this.rwl.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readLock(Lock lock, InvocationContext ctx) throws Exception {
        boolean locked = false;
        long time = lock.time();
        try {
            if (time > 0L) {
                locked = this.rwl.readLock().tryLock(time, lock.unit());
                if (!locked) {
                    throw new LockException("Read lock not acquired in " + lock.unit().toMillis(time) + " ms");
                }
            } else {
                this.rwl.readLock().lock();
                locked = true;
            }
            Object object = ctx.proceed();
            return object;
        }
        finally {
            if (locked) {
                this.rwl.readLock().unlock();
            }
        }
    }

    Lock getLock(ArcInvocationContext ctx) {
        Lock lock = ctx.findIterceptorBinding(Lock.class);
        if (lock == null) {
            throw new LockException("@Lock binding not found on business method " + String.valueOf(ctx.getMethod()));
        }
        return lock;
    }
}

