/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.mappers;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.ProtocolMapperConfigException;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.model.Role;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.util.JsonSerialization;

public class OID4VCTargetRoleMapper
extends OID4VCMapper {
    private static final Logger LOGGER = Logger.getLogger(OID4VCTargetRoleMapper.class);
    public static final String DEFAULT_CLAIM_NAME = "roles";
    public static final String CLIENT_CONFIG_KEY = "clientId";
    public static final String MAPPER_ID = "oid4vc-target-role-mapper";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();
    private final KeycloakSession keycloakSession;

    public OID4VCTargetRoleMapper() {
        this.keycloakSession = null;
    }

    public OID4VCTargetRoleMapper(KeycloakSession keycloakSession) {
        this.keycloakSession = keycloakSession;
    }

    @Override
    protected List<ProviderConfigProperty> getIndividualConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    @Override
    public List<String> getMetadataAttributePath() {
        return ListUtils.union(this.getAttributePrefix(), List.of(Optional.ofNullable((String)this.mapperModel.getConfig().get("claim.name")).orElse(DEFAULT_CLAIM_NAME)));
    }

    public String getDisplayType() {
        return "Target-Role Mapper";
    }

    public String getHelpText() {
        return "Map the assigned role to the credential subject, providing the client id as the target.";
    }

    public static ProtocolMapperModel create(String name) {
        ProtocolMapperModel mapperModel = new ProtocolMapperModel();
        mapperModel.setName(name);
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("claim.name", DEFAULT_CLAIM_NAME);
        mapperModel.setConfig(configMap);
        mapperModel.setProtocol("oid4vc");
        mapperModel.setProtocolMapper(MAPPER_ID);
        return mapperModel;
    }

    public ProtocolMapper create(KeycloakSession session) {
        return new OID4VCTargetRoleMapper(session);
    }

    public void validateConfig(KeycloakSession session, RealmModel realm, ProtocolMapperContainerModel client, ProtocolMapperModel mapperModel) throws ProtocolMapperConfigException {
        super.validateConfig(session, realm, client, mapperModel);
        if (!mapperModel.getConfig().containsKey(CLIENT_CONFIG_KEY)) {
            throw new ProtocolMapperConfigException("The OID4VCTargetRoleMapper requires a clientId to be present.");
        }
        String clientId = (String)mapperModel.getConfig().get(CLIENT_CONFIG_KEY);
        if (realm.getClientByClientId(clientId) == null) {
            throw new ProtocolMapperConfigException(String.format("ClientId %s does not exist in the realm.", clientId));
        }
    }

    public String getId() {
        return MAPPER_ID;
    }

    @Override
    public void setClaimsForCredential(VerifiableCredential verifiableCredential, UserSessionModel userSessionModel) {
    }

    @Override
    public void setClaimsForSubject(Map<String, Object> claims, UserSessionModel userSessionModel) {
        List<String> attributePath = this.getMetadataAttributePath();
        String propertyName = attributePath.get(attributePath.size() - 1);
        String client = (String)this.mapperModel.getConfig().get(CLIENT_CONFIG_KEY);
        ClientModel clientModel = userSessionModel.getRealm().getClientByClientId(client);
        if (clientModel == null) {
            LOGGER.warnf("Client %s not found.", (Object)client);
            return;
        }
        List<RoleModel> userRoles = userSessionModel.getUser().getClientRoleMappingsStream(clientModel).toList();
        if (userRoles.isEmpty()) {
            LOGGER.debugf("No roles assigned to client '%s'. Skipping claim assignment.", (Object)clientModel.getClientId());
            return;
        }
        ClientRoleModel clientRoleModel = new ClientRoleModel(clientModel.getClientId(), userRoles);
        Role rolesClaim = this.toRolesClaim(clientRoleModel);
        if (rolesClaim.getNames().isEmpty()) {
            LOGGER.debugf("No valid role names found for client '%s'. Skipping claim assignment.", (Object)clientModel.getClientId());
            return;
        }
        Map modelMap = (Map)JsonSerialization.mapper.convertValue((Object)rolesClaim, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Object existingProperty = claims.get(propertyName);
        if (existingProperty == null) {
            HashSet<Map> roles = new HashSet<Map>();
            roles.add(modelMap);
            claims.put(propertyName, roles);
        } else if (existingProperty instanceof Set) {
            Set rawSet = (Set)existingProperty;
            if (rawSet.stream().allMatch(item -> item instanceof Map)) {
                Set rolesProperty = rawSet;
                rolesProperty.add(modelMap);
            } else {
                LOGGER.warnf("Claim '%s' contains incompatible types. Expected Set<Map<String, Object>>, found '%s'. Skipping role assignment for client '%s'.", (Object)propertyName, (Object)existingProperty.getClass().getSimpleName(), (Object)clientModel.getClientId());
            }
        } else {
            LOGGER.warnf("Claim '%s' is of type '%s', expected Set. Skipping role assignment for client '%s'.", (Object)propertyName, (Object)existingProperty.getClass().getSimpleName(), (Object)clientModel.getClientId());
        }
    }

    private Role toRolesClaim(ClientRoleModel crm) {
        Set<String> roleNames = crm.getRoleModels().stream().map(RoleModel::getName).collect(Collectors.toSet());
        return new Role(roleNames, crm.getClientId());
    }

    static {
        ProviderConfigProperty subjectPropertyNameConfig = new ProviderConfigProperty();
        subjectPropertyNameConfig.setName("claim.name");
        subjectPropertyNameConfig.setLabel("Roles Property Name");
        subjectPropertyNameConfig.setHelpText("Property to add the roles to in the credential subject.");
        subjectPropertyNameConfig.setDefaultValue((Object)DEFAULT_CLAIM_NAME);
        subjectPropertyNameConfig.setType("String");
        CONFIG_PROPERTIES.add(subjectPropertyNameConfig);
        ProviderConfigProperty clientIdPropertyNameConfig = new ProviderConfigProperty();
        subjectPropertyNameConfig.setName(CLIENT_CONFIG_KEY);
        subjectPropertyNameConfig.setLabel("Client ID");
        subjectPropertyNameConfig.setHelpText("Property to configure the client to get the roles from.");
        subjectPropertyNameConfig.setType("String");
        CONFIG_PROPERTIES.add(clientIdPropertyNameConfig);
    }

    private static class ClientRoleModel {
        private final String clientId;
        private final List<RoleModel> roleModels;

        public ClientRoleModel(String clientId, List<RoleModel> roleModels) {
            this.clientId = clientId;
            this.roleModels = roleModels;
        }

        public String getClientId() {
            return this.clientId;
        }

        public List<RoleModel> getRoleModels() {
            return this.roleModels;
        }
    }
}

