/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.deployment.ClassNames;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import io.quarkus.hibernate.orm.deployment.HibernateOrmProcessor;
import io.quarkus.hibernate.orm.deployment.ImpliedBlockingPersistenceUnitTypeBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRecorder;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.RequestScopedSessionHolder;
import io.quarkus.hibernate.orm.runtime.RequestScopedStatelessSessionHolder;
import io.quarkus.hibernate.orm.runtime.TransactionSessions;
import io.quarkus.hibernate.orm.runtime.cdi.QuarkusArcBeanContainer;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import jakarta.persistence.AttributeConverter;
import jakarta.transaction.TransactionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

@BuildSteps(onlyIf={HibernateOrmEnabled.class})
public class HibernateOrmCdiProcessor {
    private static final List<DotName> SESSION_FACTORY_EXPOSED_TYPES = Arrays.asList(ClassNames.ENTITY_MANAGER_FACTORY, ClassNames.SESSION_FACTORY);
    private static final List<DotName> SESSION_EXPOSED_TYPES = Arrays.asList(ClassNames.ENTITY_MANAGER, ClassNames.SESSION);
    private static final List<DotName> STATELESS_SESSION_EXPOSED_TYPES = List.of(ClassNames.STATELESS_SESSION);
    private static final Set<DotName> PERSISTENCE_UNIT_EXTENSION_VALID_TYPES = Set.of(ClassNames.TENANT_RESOLVER, ClassNames.TENANT_CONNECTION_RESOLVER, ClassNames.INTERCEPTOR, ClassNames.STATEMENT_INSPECTOR, ClassNames.FORMAT_MAPPER);

    @BuildStep
    AnnotationsTransformerBuildItem convertJpaResourceAnnotationsToQualifier(final List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, final ImpliedBlockingPersistenceUnitTypeBuildItem impliedBlockingPersistenceUnitType) {
        AnnotationsTransformer transformer = new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.FIELD;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                DotName jpaAnnotation;
                FieldInfo field = transformationContext.getTarget().asField();
                DotName fieldTypeName = field.type().name();
                if (!SESSION_EXPOSED_TYPES.contains(fieldTypeName) && !SESSION_FACTORY_EXPOSED_TYPES.contains(fieldTypeName)) {
                    return;
                }
                if (field.hasAnnotation(ClassNames.JPA_PERSISTENCE_UNIT)) {
                    jpaAnnotation = ClassNames.JPA_PERSISTENCE_UNIT;
                } else if (field.hasAnnotation(ClassNames.JPA_PERSISTENCE_CONTEXT)) {
                    jpaAnnotation = ClassNames.JPA_PERSISTENCE_CONTEXT;
                } else {
                    return;
                }
                AnnotationValue persistenceUnitNameAnnotationValue = field.annotation(jpaAnnotation).value("unitName");
                Transformation transformation = transformationContext.transform().add(DotNames.INJECT, new AnnotationValue[0]);
                if (persistenceUnitNameAnnotationValue == null || persistenceUnitNameAnnotationValue.asString().isEmpty()) {
                    transformation.add(DotNames.DEFAULT, new AnnotationValue[0]);
                } else if (persistenceUnitDescriptors.size() == 1 && !impliedBlockingPersistenceUnitType.shouldGenerateImpliedBlockingPersistenceUnit() && ((PersistenceUnitDescriptorBuildItem)((Object)persistenceUnitDescriptors.get(0))).getPersistenceUnitName().equals(persistenceUnitNameAnnotationValue.asString())) {
                    transformation.add(DotNames.DEFAULT, new AnnotationValue[0]);
                } else {
                    transformation.add(ClassNames.QUARKUS_PERSISTENCE_UNIT, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)persistenceUnitNameAnnotationValue.asString())});
                }
                transformation.done();
            }
        };
        return new AnnotationsTransformerBuildItem(transformer);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void generateJpaConfigBean(HibernateOrmRecorder recorder, Capabilities capabilities, HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(JPAConfig.class).addType(JPAConfig.class)).scope(Singleton.class)).unremovable()).setRuntimeInit().supplier(recorder.jpaConfigSupplier(hibernateOrmRuntimeConfig)).destroyer(JPAConfig.Destroyer.class);
        if (capabilities.isPresent("io.quarkus.hibernate.reactive")) {
            configurator.addInjectionPoint((Type)ParameterizedType.create((DotName)DotName.createSimple(Instance.class), (Type[])new Type[]{ClassType.create((DotName)DotName.createSimple((String)"io.vertx.sqlclient.Pool"))}, null), new AnnotationInstance[]{AnnotationInstance.builder(Any.class).build()});
        } else {
            configurator.addInjectionPoint((Type)ParameterizedType.create((DotName)DotName.createSimple(Instance.class), (Type[])new Type[]{ClassType.create((DotName)DotName.createSimple(AgroalDataSource.class))}, null), new AnnotationInstance[]{AnnotationInstance.builder(Any.class).build()});
        }
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateDataSourceBeans(HibernateOrmRecorder recorder, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, ImpliedBlockingPersistenceUnitTypeBuildItem impliedBlockingPersistenceUnitType, List<JdbcDataSourceBuildItem> jdbcDataSources, Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (persistenceUnitDescriptors.isEmpty()) {
            return;
        }
        if (persistenceUnitDescriptors.size() == 1 && persistenceUnitDescriptors.get(0).isFromPersistenceXml()) {
            String persistenceUnitName = persistenceUnitDescriptors.get(0).getPersistenceUnitName();
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, true, true, SessionFactory.class, SESSION_FACTORY_EXPOSED_TYPES, true).createWith(recorder.sessionFactorySupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(JPAConfig.class)), new AnnotationInstance[0])).done());
            if (capabilities.isPresent("io.quarkus.transactions") && capabilities.isMissing("io.quarkus.hibernate.reactive")) {
                syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, true, true, Session.class, SESSION_EXPOSED_TYPES, false).createWith(recorder.sessionSupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(TransactionSessions.class)), new AnnotationInstance[0])).done());
                syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, true, true, StatelessSession.class, STATELESS_SESSION_EXPOSED_TYPES, false).createWith(recorder.statelessSessionSupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(TransactionSessions.class)), new AnnotationInstance[0])).done());
            }
            return;
        }
        for (PersistenceUnitDescriptorBuildItem persistenceUnitDescriptor : persistenceUnitDescriptors) {
            String persistenceUnitName = persistenceUnitDescriptor.getPersistenceUnitName();
            String persistenceUnitConfigName = persistenceUnitDescriptor.getConfigurationName();
            boolean isDefaultPU = PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitConfigName);
            boolean isNamedPU = !isDefaultPU;
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, isDefaultPU, isNamedPU, SessionFactory.class, SESSION_FACTORY_EXPOSED_TYPES, true).createWith(recorder.sessionFactorySupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(JPAConfig.class)), new AnnotationInstance[0])).done());
            if (!capabilities.isPresent("io.quarkus.transactions") || !capabilities.isMissing("io.quarkus.hibernate.reactive")) continue;
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, isDefaultPU, isNamedPU, Session.class, SESSION_EXPOSED_TYPES, false).createWith(recorder.sessionSupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(TransactionSessions.class)), new AnnotationInstance[0])).done());
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, true, true, StatelessSession.class, STATELESS_SESSION_EXPOSED_TYPES, false).createWith(recorder.statelessSessionSupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(TransactionSessions.class)), new AnnotationInstance[0])).done());
        }
    }

    @BuildStep
    void registerBeans(HibernateOrmConfig hibernateOrmConfig, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, Capabilities capabilities, CombinedIndexBuildItem combinedIndex, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaModelBuildItem jpaModel) {
        if (!HibernateOrmProcessor.hasEntities(jpaModel)) {
            return;
        }
        ArrayList<Class<RequestScopedStatelessSessionHolder>> unremovableClasses = new ArrayList<Class<RequestScopedStatelessSessionHolder>>();
        unremovableClasses.add(QuarkusArcBeanContainer.class);
        if (capabilities.isMissing("io.quarkus.hibernate.reactive")) {
            if (capabilities.isPresent("io.quarkus.transactions")) {
                unremovableClasses.add(TransactionManager.class);
                unremovableClasses.add(TransactionSessions.class);
            }
            unremovableClasses.add(RequestScopedSessionHolder.class);
            unremovableClasses.add(RequestScopedStatelessSessionHolder.class);
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(unremovableClasses.toArray(new Class[unremovableClasses.size()])).build());
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{AttributeConverter.class}));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes(jpaModel.getPotentialCdiBeanClassNames()));
    }

    @BuildStep
    void registerAnnotations(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new String[]{ClassNames.QUARKUS_PERSISTENCE_UNIT.toString(), ClassNames.PERSISTENCE_UNIT_EXTENSION.toString(), ClassNames.JSON_FORMAT.toString(), ClassNames.XML_FORMAT.toString()}).build());
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ClassNames.PERSISTENCE_UNIT_EXTENSION, DotNames.APPLICATION_SCOPED, false));
    }

    @BuildStep
    void validatePersistenceUnitExtensions(ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        List throwables = validationPhase.getContext().beans().withQualifier(new DotName[]{ClassNames.PERSISTENCE_UNIT_EXTENSION}).filter(beanInfo -> beanInfo.getTypes().stream().map(Type::name).noneMatch(PERSISTENCE_UNIT_EXTENSION_VALID_TYPES::contains)).stream().map(beanInfo -> new IllegalStateException(String.format(Locale.ROOT, "A @%s bean must implement one or more of the following types: %s. Invalid bean: %s", DotNames.simpleName((DotName)ClassNames.PERSISTENCE_UNIT_EXTENSION), PERSISTENCE_UNIT_EXTENSION_VALID_TYPES, beanInfo))).collect(Collectors.toList());
        if (!throwables.isEmpty()) {
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(throwables));
        }
    }

    private static <T> SyntheticBeanBuildItem.ExtendedBeanConfigurator createSyntheticBean(String persistenceUnitName, boolean isDefaultPersistenceUnit, boolean isNamedPersistenceUnit, Class<T> type, List<DotName> allExposedTypes, boolean defaultBean) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(type).scope(ApplicationScoped.class)).unremovable()).setRuntimeInit();
        for (DotName exposedType : allExposedTypes) {
            configurator.addType(exposedType);
        }
        if (defaultBean) {
            configurator.defaultBean();
        }
        if (isDefaultPersistenceUnit) {
            configurator.addQualifier(Default.class);
        }
        if (isNamedPersistenceUnit) {
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)persistenceUnitName).done();
            configurator.addQualifier().annotation(PersistenceUnit.class).addValue("value", (Object)persistenceUnitName).done();
        }
        return configurator;
    }
}

