/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.compatibility.CompatibilityMetadataProvider;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.AbstractUpdatesCommand;
import org.keycloak.util.JsonSerialization;
import picocli.CommandLine;

@CommandLine.Command(name="metadata", description={"Stores the metadata necessary to determine if a configuration is compatible."})
public class UpdateCompatibilityMetadata
extends AbstractUpdatesCommand {
    public static final String NAME = "metadata";
    public static final String OUTPUT_OPTION_NAME = "--file";
    @CommandLine.Option(names={"--file"}, paramLabel="FILE", description={"The file path to store the metadata. It is stored in the JSON format."})
    String outputFile;

    @Override
    int executeAction() {
        Map<String, Map<String, String>> metadata = UpdateCompatibilityMetadata.loadAllProviders().values().stream().map(Entry::new).filter(Entry::hasMetadata).collect(Collectors.toMap(Entry::id, Entry::metadata));
        this.printToConsole(metadata);
        this.writeToFile(metadata);
        return 0;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean includeRuntime() {
        return true;
    }

    @Override
    protected void validateConfig() {
        super.validateConfig();
        this.validateFileParameter();
    }

    private void validateFileParameter() {
        if (this.noOutputFileSet()) {
            return;
        }
        File file = new File(this.outputFile);
        if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new PropertyException("Incorrect argument %s. Unable to create parent directory: %s".formatted(OUTPUT_OPTION_NAME, file.getParentFile().getAbsolutePath()));
        }
        UpdateCompatibilityMetadata.validateFileIsNotDirectory(file, OUTPUT_OPTION_NAME);
    }

    private void printToConsole(Map<String, Map<String, String>> metadata) {
        try {
            String json = JsonSerialization.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(metadata);
            this.printOut("Metadata:%n%s".formatted(json));
        }
        catch (JsonProcessingException e) {
            throw new PropertyException("Unable to create JSON representation of the metadata", e);
        }
    }

    private void writeToFile(Map<String, Map<String, String>> metadata) {
        if (this.noOutputFileSet()) {
            return;
        }
        File file = new File(this.outputFile);
        try {
            JsonSerialization.mapper.writeValue(file, metadata);
        }
        catch (IOException e) {
            throw new PropertyException("Unable to write file '%s'".formatted(file.getAbsolutePath()), e);
        }
    }

    private boolean noOutputFileSet() {
        return this.outputFile == null || this.outputFile.isBlank();
    }

    private record Entry(String id, Map<String, String> metadata) {
        Entry(CompatibilityMetadataProvider provider) {
            this(provider.getId(), provider.metadata());
        }

        boolean hasMetadata() {
            return !this.metadata().isEmpty();
        }
    }
}

