/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.logging;

import io.opentelemetry.sdk.autoconfigure.spi.logs.ConfigurableLogRecordExporterProvider;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.OpenTelemetrySdkBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LogHandlerBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.opentelemetry.deployment.logging.LogsEnabled;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.logs.OpenTelemetryLogRecorder;
import io.quarkus.opentelemetry.runtime.logs.spi.LogsExporterCDIProvider;
import org.jboss.jandex.DotName;

@BuildSteps(onlyIf={LogsEnabled.class})
class LogHandlerProcessor {
    private static final DotName LOG_RECORD_EXPORTER = DotName.createSimple((String)LogRecordExporter.class.getName());
    private static final DotName LOG_RECORD_PROCESSOR = DotName.createSimple((String)LogRecordProcessor.class.getName());

    LogHandlerProcessor() {
    }

    @BuildStep
    void beanSupport(BuildProducer<UnremovableBeanBuildItem> unremovableProducer) {
        unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{LOG_RECORD_EXPORTER}));
        unremovableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{LOG_RECORD_PROCESSOR}));
    }

    @BuildStep
    void nativeSupport(BuildProducer<ServiceProviderBuildItem> servicesProducer) {
        servicesProducer.produce((BuildItem)new ServiceProviderBuildItem(ConfigurableLogRecordExporterProvider.class.getName(), new String[]{LogsExporterCDIProvider.class.getName()}));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=OpenTelemetrySdkBuildItem.class)
    LogHandlerBuildItem build(OpenTelemetryLogRecorder recorder, OTelRuntimeConfig config, BeanContainerBuildItem beanContainerBuildItem) {
        return new LogHandlerBuildItem(recorder.initializeHandler(beanContainerBuildItem.getValue(), config));
    }
}

