/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;

public class MultiOnCancellationInvoke<T>
extends AbstractMultiOperator<T, T> {
    private final Runnable action;

    public MultiOnCancellationInvoke(Multi<? extends T> upstream, Runnable action) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.action = ParameterValidation.nonNull(action, "action");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiOnCancellationInvokeProcessor(downstream));
    }

    class MultiOnCancellationInvokeProcessor
    extends MultiOperatorProcessor<T, T> {
        private final AtomicBoolean actionInvoked;

        public MultiOnCancellationInvokeProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.actionInvoked = new AtomicBoolean();
        }

        @Override
        public void onCompletion() {
            this.actionInvoked.set(true);
            super.onCompletion();
        }

        @Override
        public void cancel() {
            if (this.actionInvoked.compareAndSet(false, true)) {
                try {
                    MultiOnCancellationInvoke.this.action.run();
                }
                catch (Throwable ignored) {
                    Infrastructure.handleDroppedException(ignored);
                }
            }
            super.cancel();
        }
    }
}

