/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.dir;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.jpa.support.EntityManagers;
import org.keycloak.exportimport.AbstractFileBasedImportProvider;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.util.ExportImportSessionTask;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.platform.Platform;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.storage.datastore.DefaultExportImportManager;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.KeycloakSessionUtil;

public class DirImportProvider
extends AbstractFileBasedImportProvider {
    private final Strategy strategy;
    private final KeycloakSessionFactory factory;
    private static final Logger logger = Logger.getLogger(DirImportProvider.class);
    private File rootDirectory;
    private String realmName;

    public DirImportProvider(KeycloakSessionFactory factory, Strategy strategy) {
        this.factory = factory;
        this.strategy = strategy;
    }

    public DirImportProvider withDir(String dir) {
        this.rootDirectory = new File(dir);
        if (!this.rootDirectory.exists()) {
            throw new IllegalStateException("Directory " + String.valueOf(this.rootDirectory) + " doesn't exist");
        }
        logger.infof("Importing from directory %s", (Object)this.rootDirectory.getAbsolutePath());
        return this;
    }

    public DirImportProvider withRealmName(String realmName) {
        this.realmName = realmName;
        return this;
    }

    private File getRootDirectory() {
        if (this.rootDirectory == null) {
            this.rootDirectory = new File(Platform.getPlatform().getTmpDirectory(), "keycloak-export");
            if (!this.rootDirectory.exists()) {
                throw new IllegalStateException("Directory " + String.valueOf(this.rootDirectory) + " doesn't exist");
            }
            logger.infof("Importing from directory %s", (Object)this.rootDirectory.getAbsolutePath());
        }
        return this.rootDirectory;
    }

    public void importModel() throws IOException {
        if (this.realmName != null) {
            ServicesLogger.LOGGER.realmImportRequested(this.realmName, this.strategy.toString());
            this.importRealm(this.realmName, this.strategy);
        } else {
            ServicesLogger.LOGGER.fullModelImport(this.strategy.toString());
            List<String> realmNames = this.getRealmsToImport();
            for (String realmName : realmNames) {
                this.importRealm(realmName, this.strategy);
                Optional.ofNullable(KeycloakSessionUtil.getKeycloakSession()).ifPresent(session -> EntityManagers.flush((KeycloakSession)session, (boolean)true));
            }
        }
        ServicesLogger.LOGGER.importSuccess();
    }

    public boolean isMasterRealmExported() {
        List<String> realmNames = this.getRealmsToImport();
        return realmNames.contains(Config.getAdminRealm());
    }

    private List<String> getRealmsToImport() {
        File[] realmFiles = this.getRootDirectory().listFiles((dir, name) -> name.endsWith("-realm.json"));
        Objects.requireNonNull(realmFiles, "Directory not found: " + this.getRootDirectory().getName());
        ArrayList<String> realmNames = new ArrayList<String>();
        for (File file : realmFiles) {
            String fileName = file.getName();
            String realmName = fileName.substring(0, fileName.length() - 11);
            if (Config.getAdminRealm().equals(realmName)) {
                realmNames.add(0, realmName);
                continue;
            }
            realmNames.add(realmName);
        }
        return realmNames;
    }

    public void importRealm(final String realmName, final Strategy strategy) throws IOException {
        File realmFile = new File(String.valueOf(this.getRootDirectory()) + File.separator + realmName + "-realm.json");
        final File[] userFiles = this.getRootDirectory().listFiles((dir, name) -> name.matches(realmName + "-users-[0-9]+\\.json"));
        Objects.requireNonNull(userFiles, "directory not found: " + this.getRootDirectory().getName());
        final File[] federatedUserFiles = this.getRootDirectory().listFiles((dir, name) -> name.matches(realmName + "-federated-users-[0-9]+\\.json"));
        Objects.requireNonNull(federatedUserFiles, "directory not found: " + this.getRootDirectory().getName());
        InputStream is = this.parseFile(realmFile);
        final RealmRepresentation realmRep = (RealmRepresentation)JsonSerialization.readValue((InputStream)is, RealmRepresentation.class);
        if (!realmRep.getRealm().equals(realmName)) {
            throw new IllegalStateException(String.format("File name / realm name mismatch. %s, contains realm %s. File name should be %s", realmFile.getName(), realmRep.getRealm(), realmRep.getRealm() + "-realm.json"));
        }
        new ExportImportSessionTask(){

            @Override
            public void runExportImportTask(KeycloakSession session) {
                ImportUtils.importRealm(session, realmRep, strategy, () -> {
                    DirImportProvider.this.importUsers(realmName, userFiles, false);
                    DirImportProvider.this.importUsers(realmName, federatedUserFiles, true);
                });
            }
        }.runTask(this.factory);
    }

    private void importUsers(final String realmName, File[] userFiles, final boolean federated) {
        for (final File userFile : userFiles) {
            try (final InputStream fis = this.parseFile(userFile);){
                new ExportImportSessionTask(){

                    @Override
                    protected void runExportImportTask(KeycloakSession session) throws IOException {
                        session.getContext().setRealm(session.realms().getRealmByName(realmName));
                        ImportUtils.importUsersFromStream(session, realmName, JsonSerialization.mapper, fis, federated, (Consumer<KeycloakSession>)new DefaultExportImportManager.UserBatcher());
                        logger.infof("Imported %susers from %s", (Object)(federated ? "federated " : ""), (Object)userFile.getAbsolutePath());
                    }
                }.runTask(this.factory, ExportImportSessionTask.Mode.BATCHED);
            }
            catch (IOException e) {
                throw new RuntimeException("Error during import: " + e.getMessage(), e);
            }
        }
    }

    public void close() {
    }
}

