/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.instantiation.internal;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.query.sqm.DynamicInstantiationNature;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.instantiation.DynamicInstantiationResult;
import org.hibernate.sql.results.graph.instantiation.internal.ArgumentDomainResult;
import org.hibernate.sql.results.graph.instantiation.internal.ArgumentReader;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiationAssemblerConstructorImpl;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiationAssemblerInjectionImpl;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiationAssemblerListImpl;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiationAssemblerMapImpl;
import org.hibernate.sql.results.graph.instantiation.internal.InstantiationHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class DynamicInstantiationResultImpl<R>
implements DynamicInstantiationResult<R> {
    private static final Logger log = Logger.getLogger(DynamicInstantiationResultImpl.class);
    private final String resultVariable;
    private final DynamicInstantiationNature nature;
    private final JavaType<R> javaType;
    private final List<ArgumentDomainResult<?>> argumentResults;

    public DynamicInstantiationResultImpl(String resultVariable, DynamicInstantiationNature nature, JavaType<R> javaType, List<ArgumentDomainResult<?>> argumentResults) {
        this.resultVariable = resultVariable;
        this.nature = nature;
        this.javaType = javaType;
        this.argumentResults = argumentResults;
    }

    public JavaType<R> getResultJavaType() {
        return this.javaType;
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public boolean containsAnyNonScalarResults() {
        for (int i = 0; i < this.argumentResults.size(); ++i) {
            ArgumentDomainResult<?> argumentResult = this.argumentResults.get(i);
            if (!argumentResult.containsAnyNonScalarResults()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        for (ArgumentDomainResult<?> argumentResult : this.argumentResults) {
            argumentResult.collectValueIndexesToCache(valueIndexes);
        }
    }

    @Override
    public DomainResultAssembler<R> createResultAssembler(InitializerParent<?> parent, AssemblerCreationState creationState) {
        boolean areAllArgumentsAliased = true;
        boolean areAnyArgumentsAliased = false;
        HashSet<String> aliases = new HashSet<String>();
        ArrayList<String> duplicatedAliases = new ArrayList<String>();
        ArrayList argumentReaders = new ArrayList();
        if (this.argumentResults != null) {
            for (ArgumentDomainResult<?> argumentResult : this.argumentResults) {
                String argumentAlias = argumentResult.getResultVariable();
                if (argumentAlias == null) {
                    areAllArgumentsAliased = false;
                } else {
                    if (!aliases.add(argumentAlias)) {
                        duplicatedAliases.add(argumentAlias);
                        log.debugf("Query defined duplicate resultVariable encountered multiple declarations of [%s]", (Object)argumentAlias);
                    }
                    areAnyArgumentsAliased = true;
                }
                argumentReaders.add((ArgumentReader<?>)argumentResult.createResultAssembler((InitializerParent)parent, creationState));
            }
        }
        return this.resolveAssembler(areAllArgumentsAliased, areAnyArgumentsAliased, duplicatedAliases, argumentReaders, creationState);
    }

    private DomainResultAssembler<R> resolveAssembler(boolean areAllArgumentsAliased, boolean areAnyArgumentsAliased, List<String> duplicatedAliases, List<ArgumentReader<?>> argumentReaders, AssemblerCreationState creationState) {
        if (this.nature == DynamicInstantiationNature.LIST) {
            if (log.isDebugEnabled() && areAnyArgumentsAliased) {
                log.debug((Object)"One or more arguments for List dynamic instantiation (`new list(...)`) specified an alias; ignoring");
            }
            return new DynamicInstantiationAssemblerListImpl(this.javaType, argumentReaders);
        }
        if (this.nature == DynamicInstantiationNature.MAP) {
            if (!areAllArgumentsAliased) {
                throw new IllegalStateException("Map instantiation contained one or more arguments with no alias");
            }
            if (!duplicatedAliases.isEmpty()) {
                throw new IllegalStateException("Map instantiation has arguments with duplicate aliases [" + StringHelper.join(",", duplicatedAliases) + "]");
            }
            return new DynamicInstantiationAssemblerMapImpl(this.javaType, argumentReaders);
        }
        return this.assembler(areAllArgumentsAliased, duplicatedAliases, argumentReaders, creationState);
    }

    private DomainResultAssembler<R> assembler(boolean areAllArgumentsAliased, List<String> duplicatedAliases, List<ArgumentReader<?>> argumentReaders, AssemblerCreationState creationState) {
        List<Class<?>> argumentTypes = argumentReaders.stream().map(reader -> reader.getAssembledJavaType().getJavaTypeClass()).collect(Collectors.toList());
        TypeConfiguration typeConfiguration = creationState.getSqlAstCreationContext().getMappingMetamodel().getTypeConfiguration();
        for (Constructor<?> constructor : this.javaType.getJavaTypeClass().getDeclaredConstructors()) {
            if (!InstantiationHelper.isConstructorCompatible(constructor, argumentTypes, typeConfiguration)) continue;
            constructor.setAccessible(true);
            Constructor<?> construct = constructor;
            return new DynamicInstantiationAssemblerConstructorImpl(construct, this.javaType, argumentReaders);
        }
        if (log.isDebugEnabled()) {
            log.debugf("Could not locate appropriate constructor for dynamic instantiation of [%s]; attempting bean-injection instantiation", (Object)this.javaType.getTypeName());
        }
        if (!areAllArgumentsAliased) {
            throw new IllegalStateException("Cannot instantiate class '" + this.javaType.getTypeName() + "' (it has no constructor with signature " + String.valueOf(this.signature()) + ", and not every argument has an alias)");
        }
        if (!duplicatedAliases.isEmpty()) {
            throw new IllegalStateException("Cannot instantiate class '" + this.javaType.getTypeName() + "' (it has no constructor with signature " + String.valueOf(this.signature()) + ", and has arguments with duplicate aliases [" + StringHelper.join(",", duplicatedAliases) + "])");
        }
        return new DynamicInstantiationAssemblerInjectionImpl<R>(this.javaType, argumentReaders);
    }

    private List<String> signature() {
        return this.argumentResults.stream().map(adt -> adt.getResultJavaType().getTypeName()).collect(Collectors.toList());
    }
}

