/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.events;

import java.util.Objects;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoReserved;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.models.KeycloakSession;

@ProtoReserved(numbers={3}, names={"resendingEvent"})
public abstract class SessionClusterEvent
implements ClusterEvent {
    private String realmId;
    private String eventKey;
    private String siteId;
    private String nodeId;

    public static <T extends SessionClusterEvent> T createEvent(Class<T> eventClass, String eventKey, KeycloakSession session, String realmId) {
        try {
            SessionClusterEvent event = (SessionClusterEvent)eventClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            event.setData(session, eventKey, realmId);
            return (T)event;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void setData(KeycloakSession session, String eventKey, String realmId) {
        this.realmId = realmId;
        this.eventKey = eventKey;
        TopologyInfo topology = InfinispanUtil.getTopologyInfo(session);
        this.siteId = topology.getMySiteName();
        this.nodeId = topology.getMyNodeName();
    }

    @ProtoField(value=1)
    public String getRealmId() {
        return this.realmId;
    }

    void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    @ProtoField(value=2)
    public String getEventKey() {
        return this.eventKey;
    }

    void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    @ProtoField(value=4)
    public String getSiteId() {
        return this.siteId;
    }

    void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @ProtoField(value=5)
    public String getNodeId() {
        return this.nodeId;
    }

    void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionClusterEvent that = (SessionClusterEvent)o;
        return Objects.equals(this.realmId, that.realmId) && Objects.equals(this.eventKey, that.eventKey);
    }

    public int hashCode() {
        return Objects.hash(this.realmId, this.eventKey);
    }

    public String toString() {
        String simpleClassName = this.getClass().getSimpleName();
        return String.format("%s [ realmId=%s ]", simpleClassName, this.realmId);
    }
}

