/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import jakarta.annotation.Priority;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.IteratorUtils;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.NestedPropertyMappingInterceptor;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.WildcardPropertyMapper;

@Priority(value=4990)
public class PropertyMappingInterceptor
implements ConfigSourceInterceptor {
    private static final ThreadLocal<Boolean> disable = new ThreadLocal();

    public static void disable() {
        disable.set(true);
    }

    public static void enable() {
        disable.remove();
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        Iterable iterable = () -> context.iterateNames();
        Set<PropertyMapper<?>> allMappers = PropertyMappers.getMappers();
        boolean filterRuntime = Environment.isRebuild() != false || Environment.isRebuildCheck();
        Stream baseStream = StreamSupport.stream(iterable.spliterator(), false).flatMap(name -> {
            ConfigValue value;
            WildcardPropertyMapper<?> wildCard;
            PropertyMapper<?> mapper = PropertyMappers.getMapper(name);
            if (mapper == null) {
                return Stream.of(name);
            }
            if (filterRuntime && mapper.getCategory() == OptionCategory.CONFIG) {
                return Stream.of(new String[0]);
            }
            allMappers.remove(mapper);
            if (!mapper.hasWildcard() && name.equals(mapper.getFrom()) && (wildCard = PropertyMappers.getWildcardMappedFrom(mapper.getOption())) != null && (value = context.proceed(name)) != null && value.getValue() != null) {
                return Stream.concat(Stream.of(name), wildCard.getToFromWildcardTransformer(value.getValue()));
            }
            if (name.equals((mapper = mapper.forKey((String)name)).getFrom())) {
                return PropertyMappingInterceptor.toDistinctStream(name, mapper.getTo());
            }
            return Stream.of(name);
        });
        Stream defaultStream = allMappers.stream().filter(m -> !m.getDefaultValue().isEmpty() && !m.hasWildcard() && m.getCategory() != OptionCategory.CONFIG).flatMap(m -> PropertyMappingInterceptor.toDistinctStream(m.getTo()));
        return IteratorUtils.chainedIterator(baseStream.iterator(), defaultStream.iterator());
    }

    private static Stream<String> toDistinctStream(String ... values) {
        return Stream.of(values).filter(Objects::nonNull).distinct();
    }

    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        if (Boolean.TRUE.equals(disable.get())) {
            return context.proceed(name);
        }
        return NestedPropertyMappingInterceptor.getValueFromPropertyMappers(context, name);
    }
}

