/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.events.EventBuilder;
import org.keycloak.headers.SecurityHeadersProvider;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.adapters.action.AdminAction;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.util.JsonSerialization;

public class KeycloakOIDCIdentityProvider
extends OIDCIdentityProvider {
    public KeycloakOIDCIdentityProvider(KeycloakSession session, OIDCIdentityProviderConfig config) {
        super(session, config);
        config.setAccessTokenJwt(true);
    }

    @Override
    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new KeycloakEndpoint(callback, realm, event, this);
    }

    @Override
    protected BrokeredIdentityContext exchangeExternalTokenV1Impl(EventBuilder event, MultivaluedMap<String, String> params) {
        String subjectToken = (String)params.getFirst((Object)"subject_token");
        if (subjectToken == null) {
            event.detail("reason", "subject_token param unset");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "token not set", Response.Status.BAD_REQUEST);
        }
        String subjectTokenType = (String)params.getFirst((Object)"subject_token_type");
        if (subjectTokenType == null) {
            subjectTokenType = "urn:ietf:params:oauth:token-type:access_token";
        }
        return this.validateJwt(event, subjectToken, subjectTokenType);
    }

    protected static class KeycloakEndpoint
    extends OIDCIdentityProvider.OIDCEndpoint {
        private KeycloakOIDCIdentityProvider provider;

        public KeycloakEndpoint(IdentityProvider.AuthenticationCallback callback, RealmModel realm, EventBuilder event, KeycloakOIDCIdentityProvider provider) {
            super(callback, realm, event, provider);
            this.provider = provider;
        }

        @POST
        @Path(value="k_logout")
        public Response backchannelLogout(String input) {
            JWSInput token = null;
            try {
                token = new JWSInput(input);
            }
            catch (JWSInputException e) {
                OIDCIdentityProvider.logger.warn((Object)"Failed to verify logout request");
                return Response.status((int)400).build();
            }
            if (!this.provider.verify(token)) {
                OIDCIdentityProvider.logger.warn((Object)"Failed to verify logout request");
                return Response.status((int)400).build();
            }
            LogoutAction action = null;
            try {
                action = (LogoutAction)JsonSerialization.readValue((byte[])token.getContent(), LogoutAction.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!this.validateAction((AdminAction)action)) {
                return Response.status((int)400).build();
            }
            if (action.getKeycloakSessionIds() != null) {
                for (String sessionId : action.getKeycloakSessionIds()) {
                    String brokerSessionId = ((OIDCIdentityProviderConfig)this.provider.getConfig()).getAlias() + "." + sessionId;
                    UserSessionModel userSession = this.session.sessions().getUserSessionByBrokerSessionId(this.realm, brokerSessionId);
                    if (userSession == null || userSession.getState() == UserSessionModel.State.LOGGING_OUT || userSession.getState() == UserSessionModel.State.LOGGED_OUT) continue;
                    AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers, false);
                }
            }
            ((SecurityHeadersProvider)this.session.getProvider(SecurityHeadersProvider.class)).options().allowEmptyContentType();
            return Response.ok().build();
        }

        protected boolean validateAction(AdminAction action) {
            if (!action.validate()) {
                OIDCIdentityProvider.logger.warn((Object)("admin request failed, not validated" + action.getAction()));
                return false;
            }
            if (action.isExpired()) {
                OIDCIdentityProvider.logger.warn((Object)"admin request failed, expired token");
                return false;
            }
            if (!((OIDCIdentityProviderConfig)this.provider.getConfig()).getClientId().equals(action.getResource())) {
                OIDCIdentityProvider.logger.warn((Object)"Resource name does not match");
                return false;
            }
            return true;
        }

        @Override
        public SimpleHttp generateTokenRequest(String authorizationCode) {
            return super.generateTokenRequest(authorizationCode).param("client_session_state", "n/a");
        }
    }
}

