/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.support;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.Query;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.hibernate.exception.ConstraintViolationException;
import org.keycloak.connections.jpa.support.EntityManagers;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelIllegalStateException;

public class EntityManagerProxy {
    private static final Pattern WRITE_METHOD_NAMES = Pattern.compile("persist|merge");
    private EntityManager em;
    private final boolean batchEnabled;
    private final int batchSize;
    private int changeCount = 0;

    public static EntityManager create(KeycloakSession session, EntityManager em) {
        EntityManagerProxy converter = new EntityManagerProxy(session, em);
        HashSet<EntityManagerProxy> entityManagerProxies = (HashSet<EntityManagerProxy>)session.getAttribute("ENTITY_MANAGER_PROXIES", Set.class);
        if (entityManagerProxies == null) {
            entityManagerProxies = new HashSet<EntityManagerProxy>();
            session.setAttribute("ENTITY_MANAGER_PROXIES", entityManagerProxies);
        }
        entityManagerProxies.add(converter);
        return (EntityManager)Proxy.newProxyInstance(EntityManager.class.getClassLoader(), new Class[]{EntityManager.class}, converter::invoke);
    }

    private EntityManagerProxy(KeycloakSession session, EntityManager em) {
        this.batchEnabled = (Boolean)session.getAttributeOrDefault("org.keycloak.storage.batch_enabled", (Object)false);
        this.batchSize = (Integer)session.getAttributeOrDefault("org.keycloak.storage.batch_size", (Object)100);
        this.em = em;
    }

    void setEntityManager(EntityManager manager) {
        this.em = manager;
    }

    EntityManager getEntityManager() {
        return this.em;
    }

    private Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean batched = EntityManagers.isBatchMode();
        try {
            this.flushInBatchIfEnabled(method);
            Object result = method.invoke((Object)this.em, args);
            if (batched && result instanceof Query) {
                Query query = (Query)result;
                query.setFlushMode(FlushModeType.COMMIT);
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw EntityManagerProxy.convert(e.getCause());
        }
    }

    private void flushInBatchIfEnabled(Method method) {
        if (this.batchEnabled && WRITE_METHOD_NAMES.matcher(method.getName()).matches() && this.changeCount++ > this.batchSize) {
            this.em.flush();
            this.em.clear();
            this.changeCount = 0;
        }
    }

    public static ModelException convert(Throwable t) {
        Predicate<Throwable> checkDuplicationMessage = throwable -> {
            String message = throwable.getCause() != null ? throwable.getCause().getMessage() : throwable.getMessage();
            return message == null ? false : message.toLowerCase().contains("duplicate");
        };
        Predicate<Throwable> throwModelDuplicateEx = throwable -> throwable instanceof EntityExistsException || throwable instanceof ConstraintViolationException || EntityManagerProxy.isSqlStateClass23(throwable) || throwable instanceof SQLIntegrityConstraintViolationException;
        throwModelDuplicateEx = throwModelDuplicateEx.or(checkDuplicationMessage);
        if (t.getCause() != null && throwModelDuplicateEx.test(t.getCause())) {
            throw new ModelDuplicateException("Duplicate resource error", t.getCause());
        }
        if (throwModelDuplicateEx.test(t)) {
            throw new ModelDuplicateException("Duplicate resource error", t);
        }
        if (t instanceof OptimisticLockException) {
            throw new ModelIllegalStateException("Database operation failed", t);
        }
        throw new ModelException("Database operation failed", t);
    }

    private static boolean isSqlStateClass23(Throwable t) {
        SQLException bue;
        return t instanceof SQLException && (bue = (SQLException)t).getSQLState() != null && bue.getSQLState().startsWith("23");
    }
}

