/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import org.keycloak.config.BootstrapAdminOptions;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

public final class BootstrapAdminPropertyMappers {
    private static final String PASSWORD_SET = "bootstrap admin password is set";
    private static final String CLIENT_SECRET_SET = "bootstrap admin client secret is set";

    private BootstrapAdminPropertyMappers() {
    }

    public static PropertyMapper<?>[] getMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(BootstrapAdminOptions.USERNAME).paramLabel("username").addValidateEnabled(BootstrapAdminPropertyMappers::isPasswordSet, PASSWORD_SET).build(), PropertyMapper.fromOption(BootstrapAdminOptions.PASSWORD).paramLabel("password").isMasked(true).build(), PropertyMapper.fromOption(BootstrapAdminOptions.CLIENT_ID).paramLabel("client id").addValidateEnabled(BootstrapAdminPropertyMappers::isClientSecretSet, CLIENT_SECRET_SET).build(), PropertyMapper.fromOption(BootstrapAdminOptions.CLIENT_SECRET).paramLabel("client secret").isMasked(true).build()};
    }

    private static boolean isPasswordSet() {
        return Configuration.getOptionalKcValue(BootstrapAdminOptions.PASSWORD.getKey()).isPresent();
    }

    private static boolean isClientSecretSet() {
        return Configuration.getOptionalKcValue(BootstrapAdminOptions.CLIENT_SECRET.getKey()).isPresent();
    }
}

