/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.hibernate.Session;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.IdentityProviderStorageProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.jpa.entities.IdentityProviderEntity;
import org.keycloak.models.jpa.entities.IdentityProviderMapperEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.utils.StreamsUtil;
import org.keycloak.utils.StringUtil;

public class JpaIdentityProviderStorageProvider
implements IdentityProviderStorageProvider {
    protected static final Logger logger = Logger.getLogger(IdentityProviderStorageProvider.class);
    private final EntityManager em;
    private final KeycloakSession session;

    public JpaIdentityProviderStorageProvider(KeycloakSession session) {
        this.session = session;
        this.em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
    }

    public IdentityProviderModel create(IdentityProviderModel identityProvider) {
        IdentityProviderEntity entity = new IdentityProviderEntity();
        if (identityProvider.getInternalId() == null) {
            entity.setInternalId(KeycloakModelUtils.generateId());
        } else {
            entity.setInternalId(identityProvider.getInternalId());
        }
        entity.setAlias(identityProvider.getAlias());
        entity.setRealmId(this.getRealm().getId());
        entity.setDisplayName(identityProvider.getDisplayName());
        entity.setProviderId(identityProvider.getProviderId());
        entity.setEnabled(identityProvider.isEnabled());
        entity.setStoreToken(identityProvider.isStoreToken());
        entity.setAddReadTokenRoleOnCreate(identityProvider.isAddReadTokenRoleOnCreate());
        entity.setTrustEmail(identityProvider.isTrustEmail());
        entity.setAuthenticateByDefault(identityProvider.isAuthenticateByDefault());
        entity.setFirstBrokerLoginFlowId(identityProvider.getFirstBrokerLoginFlowId());
        entity.setPostBrokerLoginFlowId(identityProvider.getPostBrokerLoginFlowId());
        entity.setOrganizationId(identityProvider.getOrganizationId());
        entity.setConfig(identityProvider.getConfig());
        entity.setLinkOnly(identityProvider.isLinkOnly());
        entity.setHideOnLogin(identityProvider.isHideOnLogin());
        this.em.persist((Object)entity);
        this.em.flush();
        identityProvider.setInternalId(entity.getInternalId());
        return identityProvider;
    }

    public void update(IdentityProviderModel identityProvider) {
        IdentityProviderEntity entity = this.getEntityById(identityProvider.getInternalId(), true);
        entity.setAlias(identityProvider.getAlias());
        entity.setDisplayName(identityProvider.getDisplayName());
        entity.setEnabled(identityProvider.isEnabled());
        entity.setTrustEmail(identityProvider.isTrustEmail());
        entity.setAuthenticateByDefault(identityProvider.isAuthenticateByDefault());
        entity.setFirstBrokerLoginFlowId(identityProvider.getFirstBrokerLoginFlowId());
        entity.setPostBrokerLoginFlowId(identityProvider.getPostBrokerLoginFlowId());
        entity.setOrganizationId(identityProvider.getOrganizationId());
        entity.setAddReadTokenRoleOnCreate(identityProvider.isAddReadTokenRoleOnCreate());
        entity.setStoreToken(identityProvider.isStoreToken());
        entity.setConfig(identityProvider.getConfig());
        entity.setLinkOnly(identityProvider.isLinkOnly());
        entity.setHideOnLogin(identityProvider.isHideOnLogin());
        this.em.flush();
        RealmModel realm = this.getRealm();
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean remove(String alias) {
        IdentityProviderEntity entity = this.getEntityByAlias(alias);
        if (entity != null) {
            IdentityProviderModel model = this.toModel(entity);
            this.em.remove((Object)entity);
            this.em.flush();
            this.session.identityProviders().getMappersByAliasStream(alias).forEach(arg_0 -> ((IdentityProviderStorageProvider)this.session.identityProviders()).removeMapper(arg_0));
            RealmModel realm = this.getRealm();
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)new /* Unavailable Anonymous Inner Class!! */);
            return true;
        }
        return false;
    }

    public void removeAll() {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaDelete delete = builder.createCriteriaDelete(IdentityProviderEntity.class);
        Root idp = delete.from(IdentityProviderEntity.class);
        delete.where((Expression)builder.equal((Expression)idp.get("realmId"), (Object)this.getRealm().getId()));
        this.em.createQuery(delete).executeUpdate();
    }

    public IdentityProviderModel getById(String internalId) {
        return this.toModel(this.getEntityById(internalId, false));
    }

    public IdentityProviderModel getByAlias(String alias) {
        return this.toModel(this.getEntityByAlias(alias));
    }

    public Stream<IdentityProviderModel> getAllStream(Map<String, String> attrs, Integer first, Integer max) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(IdentityProviderEntity.class);
        Root idp = query.from(IdentityProviderEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)idp.get("realmId"), (Object)this.getRealm().getId()));
        if (attrs != null) {
            block20: for (Map.Entry<String, String> entry : attrs.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (StringUtil.isBlank((String)key)) continue;
                switch (key) {
                    case "authenticateByDefault": 
                    case "enabled": 
                    case "hideOnLogin": 
                    case "linkOnly": {
                        if (Boolean.parseBoolean(value)) {
                            predicates.add(builder.isTrue((Expression)idp.get(key)));
                            continue block20;
                        }
                        predicates.add(builder.isFalse((Expression)idp.get(key)));
                        continue block20;
                    }
                    case "alias": 
                    case "firstBrokerLoginFlowId": 
                    case "postBrokerLoginFlowId": 
                    case "organizationId": {
                        if (StringUtil.isBlank((String)value)) {
                            predicates.add(builder.isNull((Expression)idp.get(key)));
                            continue block20;
                        }
                        predicates.add(builder.equal((Expression)idp.get(key), (Object)value));
                        continue block20;
                    }
                    case "organizationIdNotNull": {
                        predicates.add(builder.isNotNull((Expression)idp.get("organizationId")));
                        continue block20;
                    }
                    case "search": {
                        if (!StringUtil.isNotBlank((String)value)) continue block20;
                        predicates.add(this.getAliasSearchPredicate(value, builder, (Root<IdentityProviderEntity>)idp));
                        continue block20;
                    }
                    case "aliasNotIn": {
                        if (!StringUtil.isNotBlank((String)value)) continue block20;
                        List<String> aliases = Arrays.asList(value.split(","));
                        predicates.add(builder.not((Expression)idp.get("alias").in(aliases)));
                        continue block20;
                    }
                }
                String dbProductName = (String)((Session)this.em.unwrap(Session.class)).doReturningWork(connection -> connection.getMetaData().getDatabaseProductName());
                MapJoin configJoin = idp.joinMap("config");
                Predicate configNamePredicate = builder.equal((Expression)configJoin.key(), (Object)key);
                if (dbProductName.equals("Oracle")) {
                    Predicate configValuePredicate = builder.equal(builder.function("DBMS_LOB.COMPARE", Integer.class, new Expression[]{configJoin.value(), builder.literal((Object)value)}), (Object)0);
                    predicates.add(builder.and((Expression)configNamePredicate, (Expression)configValuePredicate));
                    continue;
                }
                predicates.add(builder.and((Expression)configNamePredicate, (Expression)builder.equal((Expression)configJoin.value(), (Object)value)));
            }
        }
        query.orderBy(new Order[]{builder.asc((Expression)idp.get("alias"))});
        TypedQuery typedQuery = this.em.createQuery(query.select((Selection)idp).where((Predicate[])predicates.toArray(Predicate[]::new)));
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)typedQuery, (Integer)first, (Integer)max).getResultStream()).map(this::toModel);
    }

    public Stream<String> getByFlow(String flowId, String search, Integer first, Integer max) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(String.class);
        Root idp = query.from(IdentityProviderEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)idp.get("realmId"), (Object)this.getRealm().getId()));
        if (StringUtil.isNotBlank((String)flowId)) {
            predicates.add(builder.or((Expression)builder.equal((Expression)idp.get("firstBrokerLoginFlowId"), (Object)flowId), (Expression)builder.equal((Expression)idp.get("postBrokerLoginFlowId"), (Object)flowId)));
        }
        if (StringUtil.isNotBlank((String)search)) {
            predicates.add(this.getAliasSearchPredicate(search, builder, (Root<IdentityProviderEntity>)idp));
        }
        query.orderBy(new Order[]{builder.asc((Expression)idp.get("alias"))});
        TypedQuery typedQuery = this.em.createQuery(query.select((Selection)idp.get("alias")).where((Predicate[])predicates.toArray(Predicate[]::new)));
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)typedQuery, (Integer)first, (Integer)max).getResultStream());
    }

    public long count() {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root idp = query.from(IdentityProviderEntity.class);
        query.select((Selection)builder.count((Expression)query.from(IdentityProviderEntity.class)));
        query.where((Expression)builder.equal((Expression)idp.get("realmId"), (Object)this.getRealm().getId()));
        return (Long)this.em.createQuery(query).getSingleResult();
    }

    public void close() {
    }

    public IdentityProviderMapperModel createMapper(IdentityProviderMapperModel model) {
        this.checkUniqueMapperNamePerIdentityProvider(model);
        IdentityProviderMapperEntity entity = new IdentityProviderMapperEntity();
        entity.setId(model.getId() == null ? KeycloakModelUtils.generateId() : model.getId());
        entity.setName(model.getName());
        entity.setIdentityProviderAlias(model.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(model.getIdentityProviderMapper());
        entity.setRealmId(this.getRealm().getId());
        entity.setConfig(model.getConfig());
        this.em.persist((Object)entity);
        model.setId(entity.getId());
        return model;
    }

    public void updateMapper(IdentityProviderMapperModel model) {
        IdentityProviderMapperEntity entity = this.getMapperEntityById(model.getId(), true);
        if (!model.getName().equals(entity.getName())) {
            this.checkUniqueMapperNamePerIdentityProvider(model);
        }
        entity.setName(model.getName());
        entity.setIdentityProviderAlias(model.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(model.getIdentityProviderMapper());
        entity.setConfig(model.getConfig());
    }

    public boolean removeMapper(IdentityProviderMapperModel model) {
        this.em.remove((Object)this.getMapperEntityById(model.getId(), true));
        return true;
    }

    public void removeAllMappers() {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaDelete delete = builder.createCriteriaDelete(IdentityProviderMapperEntity.class);
        Root mapper = delete.from(IdentityProviderMapperEntity.class);
        delete.where((Expression)builder.equal((Expression)mapper.get("realmId"), (Object)this.getRealm().getId()));
        this.em.createQuery(delete).executeUpdate();
    }

    public IdentityProviderMapperModel getMapperById(String id) {
        return this.toModel(this.getMapperEntityById(id, false));
    }

    public IdentityProviderMapperModel getMapperByName(String identityProviderAlias, String name) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(IdentityProviderMapperEntity.class);
        Root mapper = query.from(IdentityProviderMapperEntity.class);
        Predicate predicate = builder.and(new Predicate[]{builder.equal((Expression)mapper.get("realmId"), (Object)this.getRealm().getId()), builder.equal((Expression)mapper.get("identityProviderAlias"), (Object)identityProviderAlias), builder.equal((Expression)mapper.get("name"), (Object)name)});
        TypedQuery typedQuery = this.em.createQuery(query.select((Selection)mapper).where((Expression)predicate));
        try {
            return this.toModel((IdentityProviderMapperEntity)typedQuery.getSingleResult());
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public Stream<IdentityProviderMapperModel> getMappersStream(Map<String, String> options, Integer first, Integer max) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(IdentityProviderMapperEntity.class);
        Root idp = query.from(IdentityProviderMapperEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)idp.get("realmId"), (Object)this.getRealm().getId()));
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (StringUtil.isBlank((String)key)) continue;
                String dbProductName = (String)((Session)this.em.unwrap(Session.class)).doReturningWork(connection -> connection.getMetaData().getDatabaseProductName());
                MapJoin configJoin = idp.joinMap("config");
                Predicate configNamePredicate = builder.equal((Expression)configJoin.key(), (Object)key);
                if (dbProductName.equals("Oracle")) {
                    Predicate configValuePredicate;
                    if (value.endsWith("*")) {
                        value = value.substring(0, value.length() - 1);
                        configValuePredicate = builder.equal(builder.function("DBMS_LOB.INSTR", Integer.class, new Expression[]{configJoin.value(), builder.literal((Object)value)}), (Object)1);
                        predicates.add(builder.and((Expression)configNamePredicate, (Expression)configValuePredicate));
                        continue;
                    }
                    configValuePredicate = builder.equal(builder.function("DBMS_LOB.COMPARE", Integer.class, new Expression[]{configJoin.value(), builder.literal((Object)value)}), (Object)0);
                    predicates.add(builder.and((Expression)configNamePredicate, (Expression)configValuePredicate));
                    continue;
                }
                if (value.endsWith("*")) {
                    value = value.replace("%", "\\%").replace("_", "\\_").replace("*", "%");
                    predicates.add(builder.and((Expression)configNamePredicate, (Expression)builder.like((Expression)configJoin.value(), value)));
                    continue;
                }
                predicates.add(builder.and((Expression)configNamePredicate, (Expression)builder.equal((Expression)configJoin.value(), (Object)value)));
            }
        }
        TypedQuery typedQuery = this.em.createQuery(query.select((Selection)idp).where((Predicate[])predicates.toArray(Predicate[]::new)));
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)typedQuery, (Integer)first, (Integer)max).getResultStream()).map(this::toModel);
    }

    public Stream<IdentityProviderMapperModel> getMappersByAliasStream(String identityProviderAlias) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(IdentityProviderMapperEntity.class);
        Root mapper = query.from(IdentityProviderMapperEntity.class);
        Predicate predicate = builder.and((Expression)builder.equal((Expression)mapper.get("realmId"), (Object)this.getRealm().getId()), (Expression)builder.equal((Expression)mapper.get("identityProviderAlias"), (Object)identityProviderAlias));
        TypedQuery typedQuery = this.em.createQuery(query.select((Selection)mapper).where((Expression)predicate).orderBy(new Order[]{builder.asc((Expression)mapper.get("id"))}));
        return StreamsUtil.closing(typedQuery.getResultStream().map(this::toModel));
    }

    private IdentityProviderEntity getEntityById(String id, boolean failIfNotFound) {
        if (id == null) {
            if (failIfNotFound) {
                throw new ModelException("Identity Provider with null internal id does not exist");
            }
            return null;
        }
        IdentityProviderEntity entity = (IdentityProviderEntity)this.em.find(IdentityProviderEntity.class, (Object)id);
        if (entity == null) {
            if (failIfNotFound) {
                throw new ModelException("Identity Provider with internal id [" + id + "] does not exist");
            }
            return null;
        }
        if (!this.getRealm().getId().equals(entity.getRealmId())) {
            throw new ModelException("Identity Provider with internal id [" + entity.getInternalId() + "] does not belong to realm [" + this.getRealm().getName() + "]");
        }
        return entity;
    }

    private IdentityProviderEntity getEntityByAlias(String alias) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(IdentityProviderEntity.class);
        Root idp = query.from(IdentityProviderEntity.class);
        Predicate predicate = builder.and((Expression)builder.equal((Expression)idp.get("realmId"), (Object)this.getRealm().getId()), (Expression)builder.equal((Expression)idp.get("alias"), (Object)alias));
        TypedQuery typedQuery = this.em.createQuery(query.select((Selection)idp).where((Expression)predicate));
        try {
            return (IdentityProviderEntity)typedQuery.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    private Predicate getAliasSearchPredicate(String search, CriteriaBuilder builder, Root<IdentityProviderEntity> idp) {
        if (((String)search).startsWith("\"") && ((String)search).endsWith("\"")) {
            search = ((String)search).substring(1, ((String)search).length() - 1);
            return builder.or((Expression)builder.equal((Expression)idp.get("alias"), search), (Expression)builder.equal((Expression)idp.get("displayName"), search));
        }
        if (!((String)(search = ((String)search).replace("%", "\\%").replace("_", "\\_").replace("*", "%"))).endsWith("%")) {
            search = (String)search + "%";
        }
        return builder.or((Expression)builder.like(builder.lower((Expression)idp.get("alias")), ((String)search).toLowerCase(), '\\'), (Expression)builder.like(builder.lower((Expression)idp.get("displayName")), ((String)search).toLowerCase(), '\\'));
    }

    private IdentityProviderModel toModel(IdentityProviderEntity entity) {
        if (entity == null) {
            return null;
        }
        IdentityProviderModel identityProviderModel = this.getModelFromProviderFactory(entity.getProviderId());
        identityProviderModel.setProviderId(entity.getProviderId());
        identityProviderModel.setAlias(entity.getAlias());
        identityProviderModel.setDisplayName(entity.getDisplayName());
        identityProviderModel.setInternalId(entity.getInternalId());
        HashMap<String, String> config = new HashMap<String, String>(entity.getConfig());
        identityProviderModel.setConfig(config);
        identityProviderModel.setEnabled(entity.isEnabled());
        identityProviderModel.setLinkOnly(entity.isLinkOnly());
        identityProviderModel.setHideOnLogin(entity.isHideOnLogin());
        identityProviderModel.setTrustEmail(entity.isTrustEmail());
        identityProviderModel.setAuthenticateByDefault(entity.isAuthenticateByDefault());
        identityProviderModel.setFirstBrokerLoginFlowId(entity.getFirstBrokerLoginFlowId());
        identityProviderModel.setPostBrokerLoginFlowId(entity.getPostBrokerLoginFlowId());
        identityProviderModel.setOrganizationId(entity.getOrganizationId());
        identityProviderModel.setStoreToken(entity.isStoreToken());
        identityProviderModel.setAddReadTokenRoleOnCreate(entity.isAddReadTokenRoleOnCreate());
        return identityProviderModel;
    }

    private IdentityProviderModel getModelFromProviderFactory(String providerId) {
        IdentityProviderFactory factory = (IdentityProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(IdentityProvider.class, providerId);
        if (factory == null) {
            factory = (IdentityProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(SocialIdentityProvider.class, providerId);
        }
        if (factory != null) {
            return factory.createConfig();
        }
        logger.warn((Object)("Couldn't find a suitable identity provider factory for " + providerId));
        return new IdentityProviderModel();
    }

    private void checkUniqueMapperNamePerIdentityProvider(IdentityProviderMapperModel model) {
        if (this.session.identityProviders().getMapperByName(model.getIdentityProviderAlias(), model.getName()) != null) {
            throw new ModelException("Identity provider mapper name must be unique per identity provider");
        }
    }

    private IdentityProviderMapperEntity getMapperEntityById(String id, boolean failIfNotFound) {
        IdentityProviderMapperEntity entity = (IdentityProviderMapperEntity)this.em.find(IdentityProviderMapperEntity.class, (Object)id);
        if (failIfNotFound && entity == null) {
            throw new ModelException("Identity Provider Mapper with id [" + id + "] does not exist");
        }
        if (entity == null) {
            return null;
        }
        if (!this.getRealm().getId().equals(entity.getRealmId())) {
            throw new ModelException("Identity Provider Mapper with id [" + entity.getId() + "] does not belong to realm [" + this.getRealm().getName() + "]");
        }
        return entity;
    }

    private IdentityProviderMapperModel toModel(IdentityProviderMapperEntity entity) {
        if (entity == null) {
            return null;
        }
        IdentityProviderMapperModel mapping = new IdentityProviderMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setIdentityProviderAlias(entity.getIdentityProviderAlias());
        mapping.setIdentityProviderMapper(entity.getIdentityProviderMapper());
        HashMap config = entity.getConfig() == null ? new HashMap() : new HashMap<String, String>(entity.getConfig());
        mapping.setConfig(config);
        return mapping;
    }

    private RealmModel getRealm() {
        RealmModel realm = this.session.getContext().getRealm();
        if (realm == null) {
            throw new IllegalStateException("Session not bound to a realm");
        }
        return realm;
    }
}

