/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.plugin.codec.ByteArrayCodec;

public class FloatArrayCodec
implements Codec<float[]> {
    public static final FloatArrayCodec INSTANCE = new FloatArrayCodec();
    private static Class<?> floatArrayClass = Array.newInstance(Float.TYPE, 0).getClass();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.BLOB, new DataType[]{DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING});
    static final int BYTES_IN_FLOAT = 4;

    @Override
    public String className() {
        return float[].class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && !type.isPrimitive() && type == floatArrayClass && type.isArray();
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof float[];
    }

    @Override
    public float[] decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return FloatArrayCodec.toFloatArray(this.getBytes(buf, length, column));
    }

    @Override
    public float[] decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return FloatArrayCodec.toFloatArray(this.getBytes(buf, length, column));
    }

    public static byte[] toByteArray(float[] floatArray) {
        ByteBuffer buffer = ByteBuffer.allocate(floatArray.length * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.asFloatBuffer().put(floatArray);
        return buffer.array();
    }

    public static float[] toFloatArray(byte[] byteArray) {
        float[] result = new float[byteArray.length / 4];
        ByteBuffer.wrap(byteArray).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().get(result, 0, result.length);
        return result;
    }

    private byte[] getBytes(ReadableByteBuf buf, MutableInt length, ColumnDecoder column) throws SQLDataException {
        switch (column.getType()) {
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case STRING: 
            case VARSTRING: 
            case VARCHAR: 
            case GEOMETRY: {
                byte[] arr = new byte[length.get()];
                buf.readBytes(arr);
                return arr;
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as float[]", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        byte[] encoded = FloatArrayCodec.toByteArray((float[])value);
        encoder.writeBytes(ByteArrayCodec.BINARY_PREFIX);
        encoder.writeBytesEscaped(encoded, encoded.length, (context.getServerStatus() & 0x200) != 0);
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        byte[] arr = FloatArrayCodec.toByteArray((float[])value);
        encoder.writeLength(arr.length);
        encoder.writeBytes(arr);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

