/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.RawString;
import io.quarkus.qute.Results;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateImpl;
import io.quarkus.qute.Variant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class StrEvalNamespaceResolver
implements NamespaceResolver {
    private volatile Engine engine;
    private final int priority;
    private final ConcurrentMap<String, Template> templates = new ConcurrentHashMap<String, Template>();

    public StrEvalNamespaceResolver() {
        this(-3);
    }

    public StrEvalNamespaceResolver(int priority) {
        this.priority = priority;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    @Override
    public CompletionStage<Object> resolve(final EvalContext context) {
        if (!"eval".equals(context.getName()) || context.getParams().size() != 1) {
            return Results.notFound(context);
        }
        CompletableFuture<Object> ret = new CompletableFuture<Object>();
        Expression p = context.getParams().get(0);
        if (p.isLiteral()) {
            String contents = p.getLiteral().toString();
            this.resolve(ret, context, this.templates.computeIfAbsent(contents, new Function<String, Template>(){

                @Override
                public Template apply(String contents) {
                    return StrEvalNamespaceResolver.this.parse(contents, context.resolutionContext().getTemplate().getVariant().orElse(null));
                }
            }));
        } else {
            context.evaluate(p).whenComplete((r, t) -> {
                if (t != null) {
                    ret.completeExceptionally((Throwable)t);
                } else {
                    this.resolve(ret, context, this.parse(r.toString(), context.resolutionContext().getTemplate().getVariant().orElse(null)));
                }
            });
        }
        return ret;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getNamespace() {
        return "str";
    }

    private Template parse(String contents, Variant variant) {
        Engine e = this.engine;
        if (e == null) {
            throw new IllegalStateException("Engine not set");
        }
        return e.parse(contents, variant);
    }

    private void resolve(CompletableFuture<Object> ret, EvalContext context, Template template) {
        ((TemplateImpl)template).root.resolve(context.resolutionContext()).whenComplete((r, t) -> {
            if (t != null) {
                ret.completeExceptionally((Throwable)t);
            } else {
                StringBuilder sb = new StringBuilder();
                r.process(sb::append);
                ret.complete(new RawString(sb.toString()));
            }
        });
    }
}

