/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.kafka.common.TopicIdPartition;

public interface PartitionRotateStrategy {
    public List<TopicIdPartition> rotate(List<TopicIdPartition> var1, PartitionRotateMetadata var2);

    public static PartitionRotateStrategy type(StrategyType type) {
        switch (type.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: 
        }
        return PartitionRotateStrategy::rotateRoundRobin;
    }

    public static List<TopicIdPartition> rotateRoundRobin(List<TopicIdPartition> topicIdPartitions, PartitionRotateMetadata metadata) {
        if (topicIdPartitions.isEmpty() || topicIdPartitions.size() == 1 || metadata.sessionEpoch < 1) {
            return topicIdPartitions;
        }
        int rotateAt = metadata.sessionEpoch % topicIdPartitions.size();
        if (rotateAt == 0) {
            return topicIdPartitions;
        }
        ArrayList<TopicIdPartition> rotatedPartitions = new ArrayList<TopicIdPartition>(topicIdPartitions);
        Collections.rotate(rotatedPartitions, -1 * rotateAt);
        return rotatedPartitions;
    }

    public static enum StrategyType {
        ROUND_ROBIN;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }

    public record PartitionRotateMetadata(int sessionEpoch) {
    }
}

